/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.Image;
import software.amazon.awssdk.services.ec2.model.ImageListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeImagesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeImagesResponse> {
    private final List<Image> images;

    private DescribeImagesResponse(BuilderImpl builder) {
        super(builder);
        this.images = builder.images;
    }

    public List<Image> images() {
        return this.images;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.images());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImagesResponse)) {
            return false;
        }
        DescribeImagesResponse other = (DescribeImagesResponse)((Object)obj);
        return Objects.equals(this.images(), other.images());
    }

    public String toString() {
        return ToString.builder((String)"DescribeImagesResponse").add("Images", this.images()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Images": {
                return Optional.ofNullable(clazz.cast(this.images()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<Image> images = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImagesResponse model) {
            super(model);
            this.images(model.images);
        }

        public final Collection<Image.Builder> getImages() {
            return this.images != null ? (Collection)this.images.stream().map(Image::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder images(Collection<Image> images) {
            this.images = ImageListCopier.copy(images);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(Image ... images) {
            this.images(Arrays.asList(images));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(Consumer<Image.Builder> ... images) {
            this.images(Stream.of(images).map(c -> (Image)((Image.Builder)Image.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setImages(Collection<Image.BuilderImpl> images) {
            this.images = ImageListCopier.copyFromBuilder(images);
        }

        @Override
        public DescribeImagesResponse build() {
            return new DescribeImagesResponse(this);
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    CopyableBuilder<Builder, DescribeImagesResponse> {
        public Builder images(Collection<Image> var1);

        public Builder images(Image ... var1);

        public Builder images(Consumer<Image.Builder> ... var1);
    }
}

