/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ConversionIdStringListCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConversionTasksRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeConversionTasksRequest> {
    private final List<String> conversionTaskIds;

    private DescribeConversionTasksRequest(BuilderImpl builder) {
        super(builder);
        this.conversionTaskIds = builder.conversionTaskIds;
    }

    public List<String> conversionTaskIds() {
        return this.conversionTaskIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.conversionTaskIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConversionTasksRequest)) {
            return false;
        }
        DescribeConversionTasksRequest other = (DescribeConversionTasksRequest)((Object)obj);
        return Objects.equals(this.conversionTaskIds(), other.conversionTaskIds());
    }

    public String toString() {
        return ToString.builder((String)"DescribeConversionTasksRequest").add("ConversionTaskIds", this.conversionTaskIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConversionTaskIds": {
                return Optional.ofNullable(clazz.cast(this.conversionTaskIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> conversionTaskIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConversionTasksRequest model) {
            super(model);
            this.conversionTaskIds(model.conversionTaskIds);
        }

        public final Collection<String> getConversionTaskIds() {
            return this.conversionTaskIds;
        }

        @Override
        public final Builder conversionTaskIds(Collection<String> conversionTaskIds) {
            this.conversionTaskIds = ConversionIdStringListCopier.copy(conversionTaskIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conversionTaskIds(String ... conversionTaskIds) {
            this.conversionTaskIds(Arrays.asList(conversionTaskIds));
            return this;
        }

        public final void setConversionTaskIds(Collection<String> conversionTaskIds) {
            this.conversionTaskIds = ConversionIdStringListCopier.copy(conversionTaskIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConversionTasksRequest build() {
            return new DescribeConversionTasksRequest(this);
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    CopyableBuilder<Builder, DescribeConversionTasksRequest> {
        public Builder conversionTaskIds(Collection<String> var1);

        public Builder conversionTaskIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

