/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteVpcEndpointServiceConfigurationsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DeleteVpcEndpointServiceConfigurationsRequest> {
    private final List<String> serviceIds;

    private DeleteVpcEndpointServiceConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.serviceIds = builder.serviceIds;
    }

    public List<String> serviceIds() {
        return this.serviceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVpcEndpointServiceConfigurationsRequest)) {
            return false;
        }
        DeleteVpcEndpointServiceConfigurationsRequest other = (DeleteVpcEndpointServiceConfigurationsRequest)((Object)obj);
        return Objects.equals(this.serviceIds(), other.serviceIds());
    }

    public String toString() {
        return ToString.builder((String)"DeleteVpcEndpointServiceConfigurationsRequest").add("ServiceIds", this.serviceIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceIds": {
                return Optional.ofNullable(clazz.cast(this.serviceIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> serviceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVpcEndpointServiceConfigurationsRequest model) {
            super(model);
            this.serviceIds(model.serviceIds);
        }

        public final Collection<String> getServiceIds() {
            return this.serviceIds;
        }

        @Override
        public final Builder serviceIds(Collection<String> serviceIds) {
            this.serviceIds = ValueStringListCopier.copy(serviceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceIds(String ... serviceIds) {
            this.serviceIds(Arrays.asList(serviceIds));
            return this;
        }

        public final void setServiceIds(Collection<String> serviceIds) {
            this.serviceIds = ValueStringListCopier.copy(serviceIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteVpcEndpointServiceConfigurationsRequest build() {
            return new DeleteVpcEndpointServiceConfigurationsRequest(this);
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    CopyableBuilder<Builder, DeleteVpcEndpointServiceConfigurationsRequest> {
        public Builder serviceIds(Collection<String> var1);

        public Builder serviceIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

