/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.VersionStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteLaunchTemplateVersionsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DeleteLaunchTemplateVersionsRequest> {
    private final String launchTemplateId;
    private final String launchTemplateName;
    private final List<String> versions;

    private DeleteLaunchTemplateVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.launchTemplateId = builder.launchTemplateId;
        this.launchTemplateName = builder.launchTemplateName;
        this.versions = builder.versions;
    }

    public String launchTemplateId() {
        return this.launchTemplateId;
    }

    public String launchTemplateName() {
        return this.launchTemplateName;
    }

    public List<String> versions() {
        return this.versions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.versions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLaunchTemplateVersionsRequest)) {
            return false;
        }
        DeleteLaunchTemplateVersionsRequest other = (DeleteLaunchTemplateVersionsRequest)((Object)obj);
        return Objects.equals(this.launchTemplateId(), other.launchTemplateId()) && Objects.equals(this.launchTemplateName(), other.launchTemplateName()) && Objects.equals(this.versions(), other.versions());
    }

    public String toString() {
        return ToString.builder((String)"DeleteLaunchTemplateVersionsRequest").add("LaunchTemplateId", (Object)this.launchTemplateId()).add("LaunchTemplateName", (Object)this.launchTemplateName()).add("Versions", this.versions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchTemplateId": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateId()));
            }
            case "LaunchTemplateName": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateName()));
            }
            case "Versions": {
                return Optional.ofNullable(clazz.cast(this.versions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String launchTemplateId;
        private String launchTemplateName;
        private List<String> versions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLaunchTemplateVersionsRequest model) {
            super(model);
            this.launchTemplateId(model.launchTemplateId);
            this.launchTemplateName(model.launchTemplateName);
            this.versions(model.versions);
        }

        public final String getLaunchTemplateId() {
            return this.launchTemplateId;
        }

        @Override
        public final Builder launchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
            return this;
        }

        public final void setLaunchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
        }

        public final String getLaunchTemplateName() {
            return this.launchTemplateName;
        }

        @Override
        public final Builder launchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
            return this;
        }

        public final void setLaunchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
        }

        public final Collection<String> getVersions() {
            return this.versions;
        }

        @Override
        public final Builder versions(Collection<String> versions) {
            this.versions = VersionStringListCopier.copy(versions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(String ... versions) {
            this.versions(Arrays.asList(versions));
            return this;
        }

        public final void setVersions(Collection<String> versions) {
            this.versions = VersionStringListCopier.copy(versions);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteLaunchTemplateVersionsRequest build() {
            return new DeleteLaunchTemplateVersionsRequest(this);
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    CopyableBuilder<Builder, DeleteLaunchTemplateVersionsRequest> {
        public Builder launchTemplateId(String var1);

        public Builder launchTemplateName(String var1);

        public Builder versions(Collection<String> var1);

        public Builder versions(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

