/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteFlowLogsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DeleteFlowLogsRequest> {
    private final List<String> flowLogIds;

    private DeleteFlowLogsRequest(BuilderImpl builder) {
        super(builder);
        this.flowLogIds = builder.flowLogIds;
    }

    public List<String> flowLogIds() {
        return this.flowLogIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.flowLogIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFlowLogsRequest)) {
            return false;
        }
        DeleteFlowLogsRequest other = (DeleteFlowLogsRequest)((Object)obj);
        return Objects.equals(this.flowLogIds(), other.flowLogIds());
    }

    public String toString() {
        return ToString.builder((String)"DeleteFlowLogsRequest").add("FlowLogIds", this.flowLogIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlowLogIds": {
                return Optional.ofNullable(clazz.cast(this.flowLogIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> flowLogIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFlowLogsRequest model) {
            super(model);
            this.flowLogIds(model.flowLogIds);
        }

        public final Collection<String> getFlowLogIds() {
            return this.flowLogIds;
        }

        @Override
        public final Builder flowLogIds(Collection<String> flowLogIds) {
            this.flowLogIds = ValueStringListCopier.copy(flowLogIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowLogIds(String ... flowLogIds) {
            this.flowLogIds(Arrays.asList(flowLogIds));
            return this;
        }

        public final void setFlowLogIds(Collection<String> flowLogIds) {
            this.flowLogIds = ValueStringListCopier.copy(flowLogIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteFlowLogsRequest build() {
            return new DeleteFlowLogsRequest(this);
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    CopyableBuilder<Builder, DeleteFlowLogsRequest> {
        public Builder flowLogIds(Collection<String> var1);

        public Builder flowLogIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

