/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.EgressOnlyInternetGateway;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEgressOnlyInternetGatewayResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CreateEgressOnlyInternetGatewayResponse> {
    private final String clientToken;
    private final EgressOnlyInternetGateway egressOnlyInternetGateway;

    private CreateEgressOnlyInternetGatewayResponse(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.egressOnlyInternetGateway = builder.egressOnlyInternetGateway;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public EgressOnlyInternetGateway egressOnlyInternetGateway() {
        return this.egressOnlyInternetGateway;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.egressOnlyInternetGateway());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEgressOnlyInternetGatewayResponse)) {
            return false;
        }
        CreateEgressOnlyInternetGatewayResponse other = (CreateEgressOnlyInternetGatewayResponse)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.egressOnlyInternetGateway(), other.egressOnlyInternetGateway());
    }

    public String toString() {
        return ToString.builder((String)"CreateEgressOnlyInternetGatewayResponse").add("ClientToken", (Object)this.clientToken()).add("EgressOnlyInternetGateway", (Object)this.egressOnlyInternetGateway()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "EgressOnlyInternetGateway": {
                return Optional.ofNullable(clazz.cast(this.egressOnlyInternetGateway()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String clientToken;
        private EgressOnlyInternetGateway egressOnlyInternetGateway;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEgressOnlyInternetGatewayResponse model) {
            super(model);
            this.clientToken(model.clientToken);
            this.egressOnlyInternetGateway(model.egressOnlyInternetGateway);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final EgressOnlyInternetGateway.Builder getEgressOnlyInternetGateway() {
            return this.egressOnlyInternetGateway != null ? this.egressOnlyInternetGateway.toBuilder() : null;
        }

        @Override
        public final Builder egressOnlyInternetGateway(EgressOnlyInternetGateway egressOnlyInternetGateway) {
            this.egressOnlyInternetGateway = egressOnlyInternetGateway;
            return this;
        }

        public final void setEgressOnlyInternetGateway(EgressOnlyInternetGateway.BuilderImpl egressOnlyInternetGateway) {
            this.egressOnlyInternetGateway = egressOnlyInternetGateway != null ? egressOnlyInternetGateway.build() : null;
        }

        @Override
        public CreateEgressOnlyInternetGatewayResponse build() {
            return new CreateEgressOnlyInternetGatewayResponse(this);
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    CopyableBuilder<Builder, CreateEgressOnlyInternetGatewayResponse> {
        public Builder clientToken(String var1);

        public Builder egressOnlyInternetGateway(EgressOnlyInternetGateway var1);

        default public Builder egressOnlyInternetGateway(Consumer<EgressOnlyInternetGateway.Builder> egressOnlyInternetGateway) {
            return this.egressOnlyInternetGateway((EgressOnlyInternetGateway)((EgressOnlyInternetGateway.Builder)EgressOnlyInternetGateway.builder().applyMutation(egressOnlyInternetGateway)).build());
        }
    }
}

