/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CpuOptionsRequest
implements ToCopyableBuilder<Builder, CpuOptionsRequest> {
    private final Integer coreCount;
    private final Integer threadsPerCore;

    private CpuOptionsRequest(BuilderImpl builder) {
        this.coreCount = builder.coreCount;
        this.threadsPerCore = builder.threadsPerCore;
    }

    public Integer coreCount() {
        return this.coreCount;
    }

    public Integer threadsPerCore() {
        return this.threadsPerCore;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.coreCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.threadsPerCore());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CpuOptionsRequest)) {
            return false;
        }
        CpuOptionsRequest other = (CpuOptionsRequest)obj;
        return Objects.equals(this.coreCount(), other.coreCount()) && Objects.equals(this.threadsPerCore(), other.threadsPerCore());
    }

    public String toString() {
        return ToString.builder((String)"CpuOptionsRequest").add("CoreCount", (Object)this.coreCount()).add("ThreadsPerCore", (Object)this.threadsPerCore()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CoreCount": {
                return Optional.ofNullable(clazz.cast(this.coreCount()));
            }
            case "ThreadsPerCore": {
                return Optional.ofNullable(clazz.cast(this.threadsPerCore()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer coreCount;
        private Integer threadsPerCore;

        private BuilderImpl() {
        }

        private BuilderImpl(CpuOptionsRequest model) {
            this.coreCount(model.coreCount);
            this.threadsPerCore(model.threadsPerCore);
        }

        public final Integer getCoreCount() {
            return this.coreCount;
        }

        @Override
        public final Builder coreCount(Integer coreCount) {
            this.coreCount = coreCount;
            return this;
        }

        public final void setCoreCount(Integer coreCount) {
            this.coreCount = coreCount;
        }

        public final Integer getThreadsPerCore() {
            return this.threadsPerCore;
        }

        @Override
        public final Builder threadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
            return this;
        }

        public final void setThreadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
        }

        public CpuOptionsRequest build() {
            return new CpuOptionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CpuOptionsRequest> {
        public Builder coreCount(Integer var1);

        public Builder threadsPerCore(Integer var1);
    }
}

