/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttachInternetGatewayRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, AttachInternetGatewayRequest> {
    private final String internetGatewayId;
    private final String vpcId;

    private AttachInternetGatewayRequest(BuilderImpl builder) {
        super(builder);
        this.internetGatewayId = builder.internetGatewayId;
        this.vpcId = builder.vpcId;
    }

    public String internetGatewayId() {
        return this.internetGatewayId;
    }

    public String vpcId() {
        return this.vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.internetGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachInternetGatewayRequest)) {
            return false;
        }
        AttachInternetGatewayRequest other = (AttachInternetGatewayRequest)((Object)obj);
        return Objects.equals(this.internetGatewayId(), other.internetGatewayId()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public String toString() {
        return ToString.builder((String)"AttachInternetGatewayRequest").add("InternetGatewayId", (Object)this.internetGatewayId()).add("VpcId", (Object)this.vpcId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InternetGatewayId": {
                return Optional.ofNullable(clazz.cast(this.internetGatewayId()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String internetGatewayId;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachInternetGatewayRequest model) {
            super(model);
            this.internetGatewayId(model.internetGatewayId);
            this.vpcId(model.vpcId);
        }

        public final String getInternetGatewayId() {
            return this.internetGatewayId;
        }

        @Override
        public final Builder internetGatewayId(String internetGatewayId) {
            this.internetGatewayId = internetGatewayId;
            return this;
        }

        public final void setInternetGatewayId(String internetGatewayId) {
            this.internetGatewayId = internetGatewayId;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AttachInternetGatewayRequest build() {
            return new AttachInternetGatewayRequest(this);
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    CopyableBuilder<Builder, AttachInternetGatewayRequest> {
        public Builder internetGatewayId(String var1);

        public Builder vpcId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

