/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.ModifyVolumeAttributeRequest;

public class ModifyVolumeAttributeRequestMarshaller
implements Marshaller<Request<ModifyVolumeAttributeRequest>, ModifyVolumeAttributeRequest> {
    public Request<ModifyVolumeAttributeRequest> marshall(ModifyVolumeAttributeRequest modifyVolumeAttributeRequest) {
        if (modifyVolumeAttributeRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyVolumeAttributeRequest, "Ec2Client");
        request.addParameter("Action", "ModifyVolumeAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyVolumeAttributeRequest.autoEnableIO() != null) {
            request.addParameter("AutoEnableIO.Value", StringConversion.fromBoolean((Boolean)modifyVolumeAttributeRequest.autoEnableIO()));
        }
        if (modifyVolumeAttributeRequest.volumeId() != null) {
            request.addParameter("VolumeId", StringConversion.fromString((String)modifyVolumeAttributeRequest.volumeId()));
        }
        return request;
    }
}

