/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.CreateVolumePermission;
import software.amazon.awssdk.services.ec2.model.CreateVolumePermissionModifications;
import software.amazon.awssdk.services.ec2.model.ModifySnapshotAttributeRequest;

public class ModifySnapshotAttributeRequestMarshaller
implements Marshaller<Request<ModifySnapshotAttributeRequest>, ModifySnapshotAttributeRequest> {
    public Request<ModifySnapshotAttributeRequest> marshall(ModifySnapshotAttributeRequest modifySnapshotAttributeRequest) {
        List<String> modifySnapshotAttributeRequestUserIdsList;
        List<String> modifySnapshotAttributeRequestGroupNamesList;
        CreateVolumePermissionModifications createVolumePermission;
        if (modifySnapshotAttributeRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifySnapshotAttributeRequest, "Ec2Client");
        request.addParameter("Action", "ModifySnapshotAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifySnapshotAttributeRequest.attributeAsString() != null) {
            request.addParameter("Attribute", StringConversion.fromString((String)modifySnapshotAttributeRequest.attributeAsString()));
        }
        if ((createVolumePermission = modifySnapshotAttributeRequest.createVolumePermission()) != null) {
            List<CreateVolumePermission> createVolumePermissionModificationsRemoveList;
            List<CreateVolumePermission> createVolumePermissionModificationsAddList = createVolumePermission.add();
            if (!createVolumePermissionModificationsAddList.isEmpty() || !(createVolumePermissionModificationsAddList instanceof SdkAutoConstructList)) {
                int addListIndex = 1;
                for (CreateVolumePermission createVolumePermission2 : createVolumePermissionModificationsAddList) {
                    if (createVolumePermission2.groupAsString() != null) {
                        request.addParameter("CreateVolumePermission.Add." + addListIndex + ".Group", StringConversion.fromString((String)createVolumePermission2.groupAsString()));
                    }
                    if (createVolumePermission2.userId() != null) {
                        request.addParameter("CreateVolumePermission.Add." + addListIndex + ".UserId", StringConversion.fromString((String)createVolumePermission2.userId()));
                    }
                    ++addListIndex;
                }
            }
            if (!(createVolumePermissionModificationsRemoveList = createVolumePermission.remove()).isEmpty() || !(createVolumePermissionModificationsRemoveList instanceof SdkAutoConstructList)) {
                int removeListIndex = 1;
                for (CreateVolumePermission createVolumePermissionModificationsRemoveListValue : createVolumePermissionModificationsRemoveList) {
                    if (createVolumePermissionModificationsRemoveListValue.groupAsString() != null) {
                        request.addParameter("CreateVolumePermission.Remove." + removeListIndex + ".Group", StringConversion.fromString((String)createVolumePermissionModificationsRemoveListValue.groupAsString()));
                    }
                    if (createVolumePermissionModificationsRemoveListValue.userId() != null) {
                        request.addParameter("CreateVolumePermission.Remove." + removeListIndex + ".UserId", StringConversion.fromString((String)createVolumePermissionModificationsRemoveListValue.userId()));
                    }
                    ++removeListIndex;
                }
            }
        }
        if (!(modifySnapshotAttributeRequestGroupNamesList = modifySnapshotAttributeRequest.groupNames()).isEmpty() || !(modifySnapshotAttributeRequestGroupNamesList instanceof SdkAutoConstructList)) {
            int groupNamesListIndex = 1;
            for (String string : modifySnapshotAttributeRequestGroupNamesList) {
                if (string != null) {
                    request.addParameter("UserGroup." + groupNamesListIndex, StringConversion.fromString((String)string));
                }
                ++groupNamesListIndex;
            }
        }
        if (modifySnapshotAttributeRequest.operationTypeAsString() != null) {
            request.addParameter("OperationType", StringConversion.fromString((String)modifySnapshotAttributeRequest.operationTypeAsString()));
        }
        if (modifySnapshotAttributeRequest.snapshotId() != null) {
            request.addParameter("SnapshotId", StringConversion.fromString((String)modifySnapshotAttributeRequest.snapshotId()));
        }
        if (!(modifySnapshotAttributeRequestUserIdsList = modifySnapshotAttributeRequest.userIds()).isEmpty() || !(modifySnapshotAttributeRequestUserIdsList instanceof SdkAutoConstructList)) {
            int userIdsListIndex = 1;
            for (String modifySnapshotAttributeRequestUserIdsListValue : modifySnapshotAttributeRequestUserIdsList) {
                if (modifySnapshotAttributeRequestUserIdsListValue != null) {
                    request.addParameter("UserId." + userIdsListIndex, StringConversion.fromString((String)modifySnapshotAttributeRequestUserIdsListValue));
                }
                ++userIdsListIndex;
            }
        }
        return request;
    }
}

