/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DiskImageDetail;
import software.amazon.awssdk.services.ec2.model.ImportVolumeRequest;
import software.amazon.awssdk.services.ec2.model.VolumeDetail;

public class ImportVolumeRequestMarshaller
implements Marshaller<Request<ImportVolumeRequest>, ImportVolumeRequest> {
    public Request<ImportVolumeRequest> marshall(ImportVolumeRequest importVolumeRequest) {
        VolumeDetail volume;
        DiskImageDetail image;
        if (importVolumeRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)importVolumeRequest, "Ec2Client");
        request.addParameter("Action", "ImportVolume");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (importVolumeRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringConversion.fromString((String)importVolumeRequest.availabilityZone()));
        }
        if (importVolumeRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)importVolumeRequest.description()));
        }
        if ((image = importVolumeRequest.image()) != null) {
            if (image.bytes() != null) {
                request.addParameter("Image.Bytes", StringConversion.fromLong((Long)image.bytes()));
            }
            if (image.formatAsString() != null) {
                request.addParameter("Image.Format", StringConversion.fromString((String)image.formatAsString()));
            }
            if (image.importManifestUrl() != null) {
                request.addParameter("Image.ImportManifestUrl", StringConversion.fromString((String)image.importManifestUrl()));
            }
        }
        if ((volume = importVolumeRequest.volume()) != null && volume.size() != null) {
            request.addParameter("Volume.Size", StringConversion.fromLong((Long)volume.size()));
        }
        return request;
    }
}

