/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeVpcEndpointsRequestMarshaller
implements Marshaller<Request<DescribeVpcEndpointsRequest>, DescribeVpcEndpointsRequest> {
    public Request<DescribeVpcEndpointsRequest> marshall(DescribeVpcEndpointsRequest describeVpcEndpointsRequest) {
        List<Filter> describeVpcEndpointsRequestFiltersList;
        if (describeVpcEndpointsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeVpcEndpointsRequest, "Ec2Client");
        request.addParameter("Action", "DescribeVpcEndpoints");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> describeVpcEndpointsRequestVpcEndpointIdsList = describeVpcEndpointsRequest.vpcEndpointIds();
        if (!describeVpcEndpointsRequestVpcEndpointIdsList.isEmpty() || !(describeVpcEndpointsRequestVpcEndpointIdsList instanceof SdkAutoConstructList)) {
            int vpcEndpointIdsListIndex = 1;
            for (String describeVpcEndpointsRequestVpcEndpointIdsListValue : describeVpcEndpointsRequestVpcEndpointIdsList) {
                if (describeVpcEndpointsRequestVpcEndpointIdsListValue != null) {
                    request.addParameter("VpcEndpointId." + vpcEndpointIdsListIndex, StringConversion.fromString((String)describeVpcEndpointsRequestVpcEndpointIdsListValue));
                }
                ++vpcEndpointIdsListIndex;
            }
        }
        if (!(describeVpcEndpointsRequestFiltersList = describeVpcEndpointsRequest.filters()).isEmpty() || !(describeVpcEndpointsRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeVpcEndpointsRequestFiltersListValue : describeVpcEndpointsRequestFiltersList) {
                List<String> filterValuesList;
                if (describeVpcEndpointsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeVpcEndpointsRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeVpcEndpointsRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeVpcEndpointsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeVpcEndpointsRequest.maxResults()));
        }
        if (describeVpcEndpointsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeVpcEndpointsRequest.nextToken()));
        }
        return request;
    }
}

