/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeSpotPriceHistoryRequestMarshaller
implements Marshaller<Request<DescribeSpotPriceHistoryRequest>, DescribeSpotPriceHistoryRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<DescribeSpotPriceHistoryRequest> marshall(DescribeSpotPriceHistoryRequest describeSpotPriceHistoryRequest) {
        List<String> describeSpotPriceHistoryRequestProductDescriptionsList;
        List<String> describeSpotPriceHistoryRequestInstanceTypesList;
        if (describeSpotPriceHistoryRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeSpotPriceHistoryRequest, "Ec2Client");
        request.addParameter("Action", "DescribeSpotPriceHistory");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeSpotPriceHistoryRequestFiltersList = describeSpotPriceHistoryRequest.filters();
        if (!describeSpotPriceHistoryRequestFiltersList.isEmpty() || !(describeSpotPriceHistoryRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter filter : describeSpotPriceHistoryRequestFiltersList) {
                List<String> filterValuesList;
                if (filter.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)filter.name()));
                }
                if (!(filterValuesList = filter.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeSpotPriceHistoryRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringConversion.fromString((String)describeSpotPriceHistoryRequest.availabilityZone()));
        }
        if (describeSpotPriceHistoryRequest.endTime() != null) {
            request.addParameter("EndTime", StringConversion.fromInstant((Instant)describeSpotPriceHistoryRequest.endTime()));
        }
        if (!(describeSpotPriceHistoryRequestInstanceTypesList = describeSpotPriceHistoryRequest.instanceTypesAsStrings()).isEmpty() || !(describeSpotPriceHistoryRequestInstanceTypesList instanceof SdkAutoConstructList)) {
            int instanceTypesListIndex = 1;
            for (String describeSpotPriceHistoryRequestInstanceTypesListValue : describeSpotPriceHistoryRequestInstanceTypesList) {
                if (describeSpotPriceHistoryRequestInstanceTypesListValue != null) {
                    request.addParameter("InstanceType." + instanceTypesListIndex, StringConversion.fromString((String)describeSpotPriceHistoryRequestInstanceTypesListValue));
                }
                ++instanceTypesListIndex;
            }
        }
        if (describeSpotPriceHistoryRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeSpotPriceHistoryRequest.maxResults()));
        }
        if (describeSpotPriceHistoryRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeSpotPriceHistoryRequest.nextToken()));
        }
        if (!(describeSpotPriceHistoryRequestProductDescriptionsList = describeSpotPriceHistoryRequest.productDescriptions()).isEmpty() || !(describeSpotPriceHistoryRequestProductDescriptionsList instanceof SdkAutoConstructList)) {
            boolean bl = true;
            for (String describeSpotPriceHistoryRequestProductDescriptionsListValue : describeSpotPriceHistoryRequestProductDescriptionsList) {
                void var6_12;
                if (describeSpotPriceHistoryRequestProductDescriptionsListValue != null) {
                    request.addParameter("ProductDescription." + (int)var6_12, StringConversion.fromString((String)describeSpotPriceHistoryRequestProductDescriptionsListValue));
                }
                ++var6_12;
            }
        }
        if (describeSpotPriceHistoryRequest.startTime() != null) {
            request.addParameter("StartTime", StringConversion.fromInstant((Instant)describeSpotPriceHistoryRequest.startTime()));
        }
        return request;
    }
}

