/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeSpotInstanceRequestsRequestMarshaller
implements Marshaller<Request<DescribeSpotInstanceRequestsRequest>, DescribeSpotInstanceRequestsRequest> {
    public Request<DescribeSpotInstanceRequestsRequest> marshall(DescribeSpotInstanceRequestsRequest describeSpotInstanceRequestsRequest) {
        List<String> describeSpotInstanceRequestsRequestSpotInstanceRequestIdsList;
        if (describeSpotInstanceRequestsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeSpotInstanceRequestsRequest, "Ec2Client");
        request.addParameter("Action", "DescribeSpotInstanceRequests");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeSpotInstanceRequestsRequestFiltersList = describeSpotInstanceRequestsRequest.filters();
        if (!describeSpotInstanceRequestsRequestFiltersList.isEmpty() || !(describeSpotInstanceRequestsRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeSpotInstanceRequestsRequestFiltersListValue : describeSpotInstanceRequestsRequestFiltersList) {
                List<String> filterValuesList;
                if (describeSpotInstanceRequestsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeSpotInstanceRequestsRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeSpotInstanceRequestsRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeSpotInstanceRequestsRequestSpotInstanceRequestIdsList = describeSpotInstanceRequestsRequest.spotInstanceRequestIds()).isEmpty() || !(describeSpotInstanceRequestsRequestSpotInstanceRequestIdsList instanceof SdkAutoConstructList)) {
            int spotInstanceRequestIdsListIndex = 1;
            for (String describeSpotInstanceRequestsRequestSpotInstanceRequestIdsListValue : describeSpotInstanceRequestsRequestSpotInstanceRequestIdsList) {
                if (describeSpotInstanceRequestsRequestSpotInstanceRequestIdsListValue != null) {
                    request.addParameter("SpotInstanceRequestId." + spotInstanceRequestIdsListIndex, StringConversion.fromString((String)describeSpotInstanceRequestsRequestSpotInstanceRequestIdsListValue));
                }
                ++spotInstanceRequestIdsListIndex;
            }
        }
        return request;
    }
}

