/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribePlacementGroupsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribePlacementGroupsRequestMarshaller
implements Marshaller<Request<DescribePlacementGroupsRequest>, DescribePlacementGroupsRequest> {
    public Request<DescribePlacementGroupsRequest> marshall(DescribePlacementGroupsRequest describePlacementGroupsRequest) {
        List<String> describePlacementGroupsRequestGroupNamesList;
        if (describePlacementGroupsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describePlacementGroupsRequest, "Ec2Client");
        request.addParameter("Action", "DescribePlacementGroups");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describePlacementGroupsRequestFiltersList = describePlacementGroupsRequest.filters();
        if (!describePlacementGroupsRequestFiltersList.isEmpty() || !(describePlacementGroupsRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describePlacementGroupsRequestFiltersListValue : describePlacementGroupsRequestFiltersList) {
                List<String> filterValuesList;
                if (describePlacementGroupsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describePlacementGroupsRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describePlacementGroupsRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describePlacementGroupsRequestGroupNamesList = describePlacementGroupsRequest.groupNames()).isEmpty() || !(describePlacementGroupsRequestGroupNamesList instanceof SdkAutoConstructList)) {
            int groupNamesListIndex = 1;
            for (String describePlacementGroupsRequestGroupNamesListValue : describePlacementGroupsRequestGroupNamesList) {
                if (describePlacementGroupsRequestGroupNamesListValue != null) {
                    request.addParameter("GroupName." + groupNamesListIndex, StringConversion.fromString((String)describePlacementGroupsRequestGroupNamesListValue));
                }
                ++groupNamesListIndex;
            }
        }
        return request;
    }
}

