/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeCustomerGatewaysRequestMarshaller
implements Marshaller<Request<DescribeCustomerGatewaysRequest>, DescribeCustomerGatewaysRequest> {
    public Request<DescribeCustomerGatewaysRequest> marshall(DescribeCustomerGatewaysRequest describeCustomerGatewaysRequest) {
        List<Filter> describeCustomerGatewaysRequestFiltersList;
        if (describeCustomerGatewaysRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeCustomerGatewaysRequest, "Ec2Client");
        request.addParameter("Action", "DescribeCustomerGateways");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> describeCustomerGatewaysRequestCustomerGatewayIdsList = describeCustomerGatewaysRequest.customerGatewayIds();
        if (!describeCustomerGatewaysRequestCustomerGatewayIdsList.isEmpty() || !(describeCustomerGatewaysRequestCustomerGatewayIdsList instanceof SdkAutoConstructList)) {
            int customerGatewayIdsListIndex = 1;
            for (String describeCustomerGatewaysRequestCustomerGatewayIdsListValue : describeCustomerGatewaysRequestCustomerGatewayIdsList) {
                if (describeCustomerGatewaysRequestCustomerGatewayIdsListValue != null) {
                    request.addParameter("CustomerGatewayId." + customerGatewayIdsListIndex, StringConversion.fromString((String)describeCustomerGatewaysRequestCustomerGatewayIdsListValue));
                }
                ++customerGatewayIdsListIndex;
            }
        }
        if (!(describeCustomerGatewaysRequestFiltersList = describeCustomerGatewaysRequest.filters()).isEmpty() || !(describeCustomerGatewaysRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeCustomerGatewaysRequestFiltersListValue : describeCustomerGatewaysRequestFiltersList) {
                List<String> filterValuesList;
                if (describeCustomerGatewaysRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeCustomerGatewaysRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeCustomerGatewaysRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

