/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DeleteVolumeRequest;

public class DeleteVolumeRequestMarshaller
implements Marshaller<Request<DeleteVolumeRequest>, DeleteVolumeRequest> {
    public Request<DeleteVolumeRequest> marshall(DeleteVolumeRequest deleteVolumeRequest) {
        if (deleteVolumeRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteVolumeRequest, "Ec2Client");
        request.addParameter("Action", "DeleteVolume");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteVolumeRequest.volumeId() != null) {
            request.addParameter("VolumeId", StringConversion.fromString((String)deleteVolumeRequest.volumeId()));
        }
        return request;
    }
}

