/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkAclEntryRequest;

public class DeleteNetworkAclEntryRequestMarshaller
implements Marshaller<Request<DeleteNetworkAclEntryRequest>, DeleteNetworkAclEntryRequest> {
    public Request<DeleteNetworkAclEntryRequest> marshall(DeleteNetworkAclEntryRequest deleteNetworkAclEntryRequest) {
        if (deleteNetworkAclEntryRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteNetworkAclEntryRequest, "Ec2Client");
        request.addParameter("Action", "DeleteNetworkAclEntry");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteNetworkAclEntryRequest.egress() != null) {
            request.addParameter("Egress", StringConversion.fromBoolean((Boolean)deleteNetworkAclEntryRequest.egress()));
        }
        if (deleteNetworkAclEntryRequest.networkAclId() != null) {
            request.addParameter("NetworkAclId", StringConversion.fromString((String)deleteNetworkAclEntryRequest.networkAclId()));
        }
        if (deleteNetworkAclEntryRequest.ruleNumber() != null) {
            request.addParameter("RuleNumber", StringConversion.fromInteger((Integer)deleteNetworkAclEntryRequest.ruleNumber()));
        }
        return request;
    }
}

