/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.CreateVpcRequest;

public class CreateVpcRequestMarshaller
implements Marshaller<Request<CreateVpcRequest>, CreateVpcRequest> {
    public Request<CreateVpcRequest> marshall(CreateVpcRequest createVpcRequest) {
        if (createVpcRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createVpcRequest, "Ec2Client");
        request.addParameter("Action", "CreateVpc");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVpcRequest.cidrBlock() != null) {
            request.addParameter("CidrBlock", StringConversion.fromString((String)createVpcRequest.cidrBlock()));
        }
        if (createVpcRequest.amazonProvidedIpv6CidrBlock() != null) {
            request.addParameter("AmazonProvidedIpv6CidrBlock", StringConversion.fromBoolean((Boolean)createVpcRequest.amazonProvidedIpv6CidrBlock()));
        }
        if (createVpcRequest.instanceTenancyAsString() != null) {
            request.addParameter("InstanceTenancy", StringConversion.fromString((String)createVpcRequest.instanceTenancyAsString()));
        }
        return request;
    }
}

