/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.CreateImageRequest;
import software.amazon.awssdk.services.ec2.model.EbsBlockDevice;

public class CreateImageRequestMarshaller
implements Marshaller<Request<CreateImageRequest>, CreateImageRequest> {
    public Request<CreateImageRequest> marshall(CreateImageRequest createImageRequest) {
        if (createImageRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createImageRequest, "Ec2Client");
        request.addParameter("Action", "CreateImage");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<BlockDeviceMapping> createImageRequestBlockDeviceMappingsList = createImageRequest.blockDeviceMappings();
        if (!createImageRequestBlockDeviceMappingsList.isEmpty() || !(createImageRequestBlockDeviceMappingsList instanceof SdkAutoConstructList)) {
            int blockDeviceMappingsListIndex = 1;
            for (BlockDeviceMapping createImageRequestBlockDeviceMappingsListValue : createImageRequestBlockDeviceMappingsList) {
                EbsBlockDevice ebs;
                if (createImageRequestBlockDeviceMappingsListValue.deviceName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringConversion.fromString((String)createImageRequestBlockDeviceMappingsListValue.deviceName()));
                }
                if (createImageRequestBlockDeviceMappingsListValue.virtualName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringConversion.fromString((String)createImageRequestBlockDeviceMappingsListValue.virtualName()));
                }
                if ((ebs = createImageRequestBlockDeviceMappingsListValue.ebs()) != null) {
                    if (ebs.encrypted() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringConversion.fromBoolean((Boolean)ebs.encrypted()));
                    }
                    if (ebs.deleteOnTermination() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringConversion.fromBoolean((Boolean)ebs.deleteOnTermination()));
                    }
                    if (ebs.iops() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringConversion.fromInteger((Integer)ebs.iops()));
                    }
                    if (ebs.snapshotId() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringConversion.fromString((String)ebs.snapshotId()));
                    }
                    if (ebs.volumeSize() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringConversion.fromInteger((Integer)ebs.volumeSize()));
                    }
                    if (ebs.volumeTypeAsString() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringConversion.fromString((String)ebs.volumeTypeAsString()));
                    }
                }
                if (createImageRequestBlockDeviceMappingsListValue.noDevice() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringConversion.fromString((String)createImageRequestBlockDeviceMappingsListValue.noDevice()));
                }
                ++blockDeviceMappingsListIndex;
            }
        }
        if (createImageRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)createImageRequest.description()));
        }
        if (createImageRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringConversion.fromString((String)createImageRequest.instanceId()));
        }
        if (createImageRequest.name() != null) {
            request.addParameter("Name", StringConversion.fromString((String)createImageRequest.name()));
        }
        if (createImageRequest.noReboot() != null) {
            request.addParameter("NoReboot", StringConversion.fromBoolean((Boolean)createImageRequest.noReboot()));
        }
        return request;
    }
}

