/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.CreateFlowLogsRequest;

public class CreateFlowLogsRequestMarshaller
implements Marshaller<Request<CreateFlowLogsRequest>, CreateFlowLogsRequest> {
    public Request<CreateFlowLogsRequest> marshall(CreateFlowLogsRequest createFlowLogsRequest) {
        List<String> createFlowLogsRequestResourceIdsList;
        if (createFlowLogsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createFlowLogsRequest, "Ec2Client");
        request.addParameter("Action", "CreateFlowLogs");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createFlowLogsRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringConversion.fromString((String)createFlowLogsRequest.clientToken()));
        }
        if (createFlowLogsRequest.deliverLogsPermissionArn() != null) {
            request.addParameter("DeliverLogsPermissionArn", StringConversion.fromString((String)createFlowLogsRequest.deliverLogsPermissionArn()));
        }
        if (createFlowLogsRequest.logGroupName() != null) {
            request.addParameter("LogGroupName", StringConversion.fromString((String)createFlowLogsRequest.logGroupName()));
        }
        if (!(createFlowLogsRequestResourceIdsList = createFlowLogsRequest.resourceIds()).isEmpty() || !(createFlowLogsRequestResourceIdsList instanceof SdkAutoConstructList)) {
            int resourceIdsListIndex = 1;
            for (String createFlowLogsRequestResourceIdsListValue : createFlowLogsRequestResourceIdsList) {
                if (createFlowLogsRequestResourceIdsListValue != null) {
                    request.addParameter("ResourceId." + resourceIdsListIndex, StringConversion.fromString((String)createFlowLogsRequestResourceIdsListValue));
                }
                ++resourceIdsListIndex;
            }
        }
        if (createFlowLogsRequest.resourceTypeAsString() != null) {
            request.addParameter("ResourceType", StringConversion.fromString((String)createFlowLogsRequest.resourceTypeAsString()));
        }
        if (createFlowLogsRequest.trafficTypeAsString() != null) {
            request.addParameter("TrafficType", StringConversion.fromString((String)createFlowLogsRequest.trafficTypeAsString()));
        }
        return request;
    }
}

