/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.CopyImageRequest;

public class CopyImageRequestMarshaller
implements Marshaller<Request<CopyImageRequest>, CopyImageRequest> {
    public Request<CopyImageRequest> marshall(CopyImageRequest copyImageRequest) {
        if (copyImageRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)copyImageRequest, "Ec2Client");
        request.addParameter("Action", "CopyImage");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (copyImageRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringConversion.fromString((String)copyImageRequest.clientToken()));
        }
        if (copyImageRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)copyImageRequest.description()));
        }
        if (copyImageRequest.encrypted() != null) {
            request.addParameter("Encrypted", StringConversion.fromBoolean((Boolean)copyImageRequest.encrypted()));
        }
        if (copyImageRequest.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringConversion.fromString((String)copyImageRequest.kmsKeyId()));
        }
        if (copyImageRequest.name() != null) {
            request.addParameter("Name", StringConversion.fromString((String)copyImageRequest.name()));
        }
        if (copyImageRequest.sourceImageId() != null) {
            request.addParameter("SourceImageId", StringConversion.fromString((String)copyImageRequest.sourceImageId()));
        }
        if (copyImageRequest.sourceRegion() != null) {
            request.addParameter("SourceRegion", StringConversion.fromString((String)copyImageRequest.sourceRegion()));
        }
        return request;
    }
}

