/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.CopyFpgaImageRequest;

public class CopyFpgaImageRequestMarshaller
implements Marshaller<Request<CopyFpgaImageRequest>, CopyFpgaImageRequest> {
    public Request<CopyFpgaImageRequest> marshall(CopyFpgaImageRequest copyFpgaImageRequest) {
        if (copyFpgaImageRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)copyFpgaImageRequest, "Ec2Client");
        request.addParameter("Action", "CopyFpgaImage");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (copyFpgaImageRequest.sourceFpgaImageId() != null) {
            request.addParameter("SourceFpgaImageId", StringConversion.fromString((String)copyFpgaImageRequest.sourceFpgaImageId()));
        }
        if (copyFpgaImageRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)copyFpgaImageRequest.description()));
        }
        if (copyFpgaImageRequest.name() != null) {
            request.addParameter("Name", StringConversion.fromString((String)copyFpgaImageRequest.name()));
        }
        if (copyFpgaImageRequest.sourceRegion() != null) {
            request.addParameter("SourceRegion", StringConversion.fromString((String)copyFpgaImageRequest.sourceRegion()));
        }
        if (copyFpgaImageRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringConversion.fromString((String)copyFpgaImageRequest.clientToken()));
        }
        return request;
    }
}

