/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.CancelBundleTaskRequest;

public class CancelBundleTaskRequestMarshaller
implements Marshaller<Request<CancelBundleTaskRequest>, CancelBundleTaskRequest> {
    public Request<CancelBundleTaskRequest> marshall(CancelBundleTaskRequest cancelBundleTaskRequest) {
        if (cancelBundleTaskRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)cancelBundleTaskRequest, "Ec2Client");
        request.addParameter("Action", "CancelBundleTask");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (cancelBundleTaskRequest.bundleId() != null) {
            request.addParameter("BundleId", StringConversion.fromString((String)cancelBundleTaskRequest.bundleId()));
        }
        return request;
    }
}

