/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryResponse;
import software.amazon.awssdk.services.ec2.model.SpotPrice;

public class DescribeSpotPriceHistoryIterable
implements SdkIterable<DescribeSpotPriceHistoryResponse> {
    private final Ec2Client client;
    private final DescribeSpotPriceHistoryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeSpotPriceHistoryIterable(Ec2Client client, DescribeSpotPriceHistoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeSpotPriceHistoryResponseFetcher();
    }

    public Iterator<DescribeSpotPriceHistoryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SpotPrice> spotPriceHistory() {
        Function<DescribeSpotPriceHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.spotPriceHistory() != null) {
                return response.spotPriceHistory().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeSpotPriceHistoryIterable resume(DescribeSpotPriceHistoryResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeSpotPriceHistoryIterable(this.client, (DescribeSpotPriceHistoryRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeSpotPriceHistoryIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeSpotPriceHistoryResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeSpotPriceHistoryResponseFetcher
    implements SyncPageFetcher<DescribeSpotPriceHistoryResponse> {
        private DescribeSpotPriceHistoryResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSpotPriceHistoryResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public DescribeSpotPriceHistoryResponse nextPage(DescribeSpotPriceHistoryResponse previousPage) {
            if (previousPage == null) {
                return DescribeSpotPriceHistoryIterable.this.client.describeSpotPriceHistory(DescribeSpotPriceHistoryIterable.this.firstRequest);
            }
            return DescribeSpotPriceHistoryIterable.this.client.describeSpotPriceHistory((DescribeSpotPriceHistoryRequest)((Object)DescribeSpotPriceHistoryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

