/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SlotDateTimeRangeRequest
implements ToCopyableBuilder<Builder, SlotDateTimeRangeRequest> {
    private final Instant earliestTime;
    private final Instant latestTime;

    private SlotDateTimeRangeRequest(BuilderImpl builder) {
        this.earliestTime = builder.earliestTime;
        this.latestTime = builder.latestTime;
    }

    public Instant earliestTime() {
        return this.earliestTime;
    }

    public Instant latestTime() {
        return this.latestTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.earliestTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlotDateTimeRangeRequest)) {
            return false;
        }
        SlotDateTimeRangeRequest other = (SlotDateTimeRangeRequest)obj;
        return Objects.equals(this.earliestTime(), other.earliestTime()) && Objects.equals(this.latestTime(), other.latestTime());
    }

    public String toString() {
        return ToString.builder((String)"SlotDateTimeRangeRequest").add("EarliestTime", (Object)this.earliestTime()).add("LatestTime", (Object)this.latestTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EarliestTime": {
                return Optional.ofNullable(clazz.cast(this.earliestTime()));
            }
            case "LatestTime": {
                return Optional.ofNullable(clazz.cast(this.latestTime()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Instant earliestTime;
        private Instant latestTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SlotDateTimeRangeRequest model) {
            this.earliestTime(model.earliestTime);
            this.latestTime(model.latestTime);
        }

        public final Instant getEarliestTime() {
            return this.earliestTime;
        }

        @Override
        public final Builder earliestTime(Instant earliestTime) {
            this.earliestTime = earliestTime;
            return this;
        }

        public final void setEarliestTime(Instant earliestTime) {
            this.earliestTime = earliestTime;
        }

        public final Instant getLatestTime() {
            return this.latestTime;
        }

        @Override
        public final Builder latestTime(Instant latestTime) {
            this.latestTime = latestTime;
            return this;
        }

        public final void setLatestTime(Instant latestTime) {
            this.latestTime = latestTime;
        }

        public SlotDateTimeRangeRequest build() {
            return new SlotDateTimeRangeRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SlotDateTimeRangeRequest> {
        public Builder earliestTime(Instant var1);

        public Builder latestTime(Instant var1);
    }
}

