/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfileSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplaceIamInstanceProfileAssociationRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ReplaceIamInstanceProfileAssociationRequest> {
    private final IamInstanceProfileSpecification iamInstanceProfile;
    private final String associationId;

    private ReplaceIamInstanceProfileAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.associationId = builder.associationId;
    }

    public IamInstanceProfileSpecification iamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public String associationId() {
        return this.associationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplaceIamInstanceProfileAssociationRequest)) {
            return false;
        }
        ReplaceIamInstanceProfileAssociationRequest other = (ReplaceIamInstanceProfileAssociationRequest)((Object)obj);
        return Objects.equals(this.iamInstanceProfile(), other.iamInstanceProfile()) && Objects.equals(this.associationId(), other.associationId());
    }

    public String toString() {
        return ToString.builder((String)"ReplaceIamInstanceProfileAssociationRequest").add("IamInstanceProfile", (Object)this.iamInstanceProfile()).add("AssociationId", (Object)this.associationId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IamInstanceProfile": {
                return Optional.ofNullable(clazz.cast(this.iamInstanceProfile()));
            }
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private IamInstanceProfileSpecification iamInstanceProfile;
        private String associationId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplaceIamInstanceProfileAssociationRequest model) {
            super(model);
            this.iamInstanceProfile(model.iamInstanceProfile);
            this.associationId(model.associationId);
        }

        public final IamInstanceProfileSpecification.Builder getIamInstanceProfile() {
            return this.iamInstanceProfile != null ? this.iamInstanceProfile.toBuilder() : null;
        }

        @Override
        public final Builder iamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(IamInstanceProfileSpecification.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReplaceIamInstanceProfileAssociationRequest build() {
            return new ReplaceIamInstanceProfileAssociationRequest(this);
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    CopyableBuilder<Builder, ReplaceIamInstanceProfileAssociationRequest> {
        public Builder iamInstanceProfile(IamInstanceProfileSpecification var1);

        default public Builder iamInstanceProfile(Consumer<IamInstanceProfileSpecification.Builder> iamInstanceProfile) {
            return this.iamInstanceProfile((IamInstanceProfileSpecification)((IamInstanceProfileSpecification.Builder)IamInstanceProfileSpecification.builder().applyMutation(iamInstanceProfile)).build());
        }

        public Builder associationId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

