/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.VpcTenancy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyVpcTenancyRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyVpcTenancyRequest> {
    private final String vpcId;
    private final String instanceTenancy;

    private ModifyVpcTenancyRequest(BuilderImpl builder) {
        super(builder);
        this.vpcId = builder.vpcId;
        this.instanceTenancy = builder.instanceTenancy;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public VpcTenancy instanceTenancy() {
        return VpcTenancy.fromValue(this.instanceTenancy);
    }

    public String instanceTenancyAsString() {
        return this.instanceTenancy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTenancyAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcTenancyRequest)) {
            return false;
        }
        ModifyVpcTenancyRequest other = (ModifyVpcTenancyRequest)((Object)obj);
        return Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.instanceTenancyAsString(), other.instanceTenancyAsString());
    }

    public String toString() {
        return ToString.builder((String)"ModifyVpcTenancyRequest").add("VpcId", (Object)this.vpcId()).add("InstanceTenancy", (Object)this.instanceTenancyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "InstanceTenancy": {
                return Optional.ofNullable(clazz.cast(this.instanceTenancyAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String vpcId;
        private String instanceTenancy;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcTenancyRequest model) {
            super(model);
            this.vpcId(model.vpcId);
            this.instanceTenancy(model.instanceTenancy);
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getInstanceTenancy() {
            return this.instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(VpcTenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy.toString());
            return this;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpcTenancyRequest build() {
            return new ModifyVpcTenancyRequest(this);
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    CopyableBuilder<Builder, ModifyVpcTenancyRequest> {
        public Builder vpcId(String var1);

        public Builder instanceTenancy(String var1);

        public Builder instanceTenancy(VpcTenancy var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

