/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.PermissionGroup;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoadPermissionRequest
implements ToCopyableBuilder<Builder, LoadPermissionRequest> {
    private final String group;
    private final String userId;

    private LoadPermissionRequest(BuilderImpl builder) {
        this.group = builder.group;
        this.userId = builder.userId;
    }

    public PermissionGroup group() {
        return PermissionGroup.fromValue(this.group);
    }

    public String groupAsString() {
        return this.group;
    }

    public String userId() {
        return this.userId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadPermissionRequest)) {
            return false;
        }
        LoadPermissionRequest other = (LoadPermissionRequest)obj;
        return Objects.equals(this.groupAsString(), other.groupAsString()) && Objects.equals(this.userId(), other.userId());
    }

    public String toString() {
        return ToString.builder((String)"LoadPermissionRequest").add("Group", (Object)this.groupAsString()).add("UserId", (Object)this.userId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Group": {
                return Optional.ofNullable(clazz.cast(this.groupAsString()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String group;
        private String userId;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadPermissionRequest model) {
            this.group(model.group);
            this.userId(model.userId);
        }

        public final String getGroup() {
            return this.group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        @Override
        public final Builder group(PermissionGroup group) {
            this.group(group.toString());
            return this;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public LoadPermissionRequest build() {
            return new LoadPermissionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LoadPermissionRequest> {
        public Builder group(String var1);

        public Builder group(PermissionGroup var1);

        public Builder userId(String var1);
    }
}

