/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KeyPair
implements ToCopyableBuilder<Builder, KeyPair> {
    private final String keyFingerprint;
    private final String keyMaterial;
    private final String keyName;

    private KeyPair(BuilderImpl builder) {
        this.keyFingerprint = builder.keyFingerprint;
        this.keyMaterial = builder.keyMaterial;
        this.keyName = builder.keyName;
    }

    public String keyFingerprint() {
        return this.keyFingerprint;
    }

    public String keyMaterial() {
        return this.keyMaterial;
    }

    public String keyName() {
        return this.keyName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyFingerprint());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyMaterial());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyPair)) {
            return false;
        }
        KeyPair other = (KeyPair)obj;
        return Objects.equals(this.keyFingerprint(), other.keyFingerprint()) && Objects.equals(this.keyMaterial(), other.keyMaterial()) && Objects.equals(this.keyName(), other.keyName());
    }

    public String toString() {
        return ToString.builder((String)"KeyPair").add("KeyFingerprint", (Object)this.keyFingerprint()).add("KeyMaterial", (Object)this.keyMaterial()).add("KeyName", (Object)this.keyName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyFingerprint": {
                return Optional.ofNullable(clazz.cast(this.keyFingerprint()));
            }
            case "KeyMaterial": {
                return Optional.ofNullable(clazz.cast(this.keyMaterial()));
            }
            case "KeyName": {
                return Optional.ofNullable(clazz.cast(this.keyName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String keyFingerprint;
        private String keyMaterial;
        private String keyName;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyPair model) {
            this.keyFingerprint(model.keyFingerprint);
            this.keyMaterial(model.keyMaterial);
            this.keyName(model.keyName);
        }

        public final String getKeyFingerprint() {
            return this.keyFingerprint;
        }

        @Override
        public final Builder keyFingerprint(String keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
            return this;
        }

        public final void setKeyFingerprint(String keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
        }

        public final String getKeyMaterial() {
            return this.keyMaterial;
        }

        @Override
        public final Builder keyMaterial(String keyMaterial) {
            this.keyMaterial = keyMaterial;
            return this;
        }

        public final void setKeyMaterial(String keyMaterial) {
            this.keyMaterial = keyMaterial;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public KeyPair build() {
            return new KeyPair(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, KeyPair> {
        public Builder keyFingerprint(String var1);

        public Builder keyMaterial(String var1);

        public Builder keyName(String var1);
    }
}

