/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.VpcEndpoint;
import software.amazon.awssdk.services.ec2.model.VpcEndpointSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVpcEndpointsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeVpcEndpointsResponse> {
    private final List<VpcEndpoint> vpcEndpoints;
    private final String nextToken;

    private DescribeVpcEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.vpcEndpoints = builder.vpcEndpoints;
        this.nextToken = builder.nextToken;
    }

    public List<VpcEndpoint> vpcEndpoints() {
        return this.vpcEndpoints;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpoints());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcEndpointsResponse)) {
            return false;
        }
        DescribeVpcEndpointsResponse other = (DescribeVpcEndpointsResponse)((Object)obj);
        return Objects.equals(this.vpcEndpoints(), other.vpcEndpoints()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeVpcEndpointsResponse").add("VpcEndpoints", this.vpcEndpoints()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcEndpoints": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpoints()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<VpcEndpoint> vpcEndpoints = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcEndpointsResponse model) {
            super(model);
            this.vpcEndpoints(model.vpcEndpoints);
            this.nextToken(model.nextToken);
        }

        public final Collection<VpcEndpoint.Builder> getVpcEndpoints() {
            return this.vpcEndpoints != null ? (Collection)this.vpcEndpoints.stream().map(VpcEndpoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpcEndpoints(Collection<VpcEndpoint> vpcEndpoints) {
            this.vpcEndpoints = VpcEndpointSetCopier.copy(vpcEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpoints(VpcEndpoint ... vpcEndpoints) {
            this.vpcEndpoints(Arrays.asList(vpcEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpoints(Consumer<VpcEndpoint.Builder> ... vpcEndpoints) {
            this.vpcEndpoints(Stream.of(vpcEndpoints).map(c -> (VpcEndpoint)((VpcEndpoint.Builder)VpcEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVpcEndpoints(Collection<VpcEndpoint.BuilderImpl> vpcEndpoints) {
            this.vpcEndpoints = VpcEndpointSetCopier.copyFromBuilder(vpcEndpoints);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeVpcEndpointsResponse build() {
            return new DescribeVpcEndpointsResponse(this);
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    CopyableBuilder<Builder, DescribeVpcEndpointsResponse> {
        public Builder vpcEndpoints(Collection<VpcEndpoint> var1);

        public Builder vpcEndpoints(VpcEndpoint ... var1);

        public Builder vpcEndpoints(Consumer<VpcEndpoint.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

