/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.MovingAddressStatus;
import software.amazon.awssdk.services.ec2.model.MovingAddressStatusSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMovingAddressesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeMovingAddressesResponse> {
    private final List<MovingAddressStatus> movingAddressStatuses;
    private final String nextToken;

    private DescribeMovingAddressesResponse(BuilderImpl builder) {
        super(builder);
        this.movingAddressStatuses = builder.movingAddressStatuses;
        this.nextToken = builder.nextToken;
    }

    public List<MovingAddressStatus> movingAddressStatuses() {
        return this.movingAddressStatuses;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.movingAddressStatuses());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMovingAddressesResponse)) {
            return false;
        }
        DescribeMovingAddressesResponse other = (DescribeMovingAddressesResponse)((Object)obj);
        return Objects.equals(this.movingAddressStatuses(), other.movingAddressStatuses()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeMovingAddressesResponse").add("MovingAddressStatuses", this.movingAddressStatuses()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MovingAddressStatuses": {
                return Optional.ofNullable(clazz.cast(this.movingAddressStatuses()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<MovingAddressStatus> movingAddressStatuses = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMovingAddressesResponse model) {
            super(model);
            this.movingAddressStatuses(model.movingAddressStatuses);
            this.nextToken(model.nextToken);
        }

        public final Collection<MovingAddressStatus.Builder> getMovingAddressStatuses() {
            return this.movingAddressStatuses != null ? (Collection)this.movingAddressStatuses.stream().map(MovingAddressStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder movingAddressStatuses(Collection<MovingAddressStatus> movingAddressStatuses) {
            this.movingAddressStatuses = MovingAddressStatusSetCopier.copy(movingAddressStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder movingAddressStatuses(MovingAddressStatus ... movingAddressStatuses) {
            this.movingAddressStatuses(Arrays.asList(movingAddressStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder movingAddressStatuses(Consumer<MovingAddressStatus.Builder> ... movingAddressStatuses) {
            this.movingAddressStatuses(Stream.of(movingAddressStatuses).map(c -> (MovingAddressStatus)((MovingAddressStatus.Builder)MovingAddressStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMovingAddressStatuses(Collection<MovingAddressStatus.BuilderImpl> movingAddressStatuses) {
            this.movingAddressStatuses = MovingAddressStatusSetCopier.copyFromBuilder(movingAddressStatuses);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeMovingAddressesResponse build() {
            return new DescribeMovingAddressesResponse(this);
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    CopyableBuilder<Builder, DescribeMovingAddressesResponse> {
        public Builder movingAddressStatuses(Collection<MovingAddressStatus> var1);

        public Builder movingAddressStatuses(MovingAddressStatus ... var1);

        public Builder movingAddressStatuses(Consumer<MovingAddressStatus.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

