/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ImportSnapshotTask;
import software.amazon.awssdk.services.ec2.model.ImportSnapshotTaskListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeImportSnapshotTasksResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeImportSnapshotTasksResponse> {
    private final List<ImportSnapshotTask> importSnapshotTasks;
    private final String nextToken;

    private DescribeImportSnapshotTasksResponse(BuilderImpl builder) {
        super(builder);
        this.importSnapshotTasks = builder.importSnapshotTasks;
        this.nextToken = builder.nextToken;
    }

    public List<ImportSnapshotTask> importSnapshotTasks() {
        return this.importSnapshotTasks;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.importSnapshotTasks());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImportSnapshotTasksResponse)) {
            return false;
        }
        DescribeImportSnapshotTasksResponse other = (DescribeImportSnapshotTasksResponse)((Object)obj);
        return Objects.equals(this.importSnapshotTasks(), other.importSnapshotTasks()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeImportSnapshotTasksResponse").add("ImportSnapshotTasks", this.importSnapshotTasks()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImportSnapshotTasks": {
                return Optional.ofNullable(clazz.cast(this.importSnapshotTasks()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<ImportSnapshotTask> importSnapshotTasks = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImportSnapshotTasksResponse model) {
            super(model);
            this.importSnapshotTasks(model.importSnapshotTasks);
            this.nextToken(model.nextToken);
        }

        public final Collection<ImportSnapshotTask.Builder> getImportSnapshotTasks() {
            return this.importSnapshotTasks != null ? (Collection)this.importSnapshotTasks.stream().map(ImportSnapshotTask::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder importSnapshotTasks(Collection<ImportSnapshotTask> importSnapshotTasks) {
            this.importSnapshotTasks = ImportSnapshotTaskListCopier.copy(importSnapshotTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importSnapshotTasks(ImportSnapshotTask ... importSnapshotTasks) {
            this.importSnapshotTasks(Arrays.asList(importSnapshotTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importSnapshotTasks(Consumer<ImportSnapshotTask.Builder> ... importSnapshotTasks) {
            this.importSnapshotTasks(Stream.of(importSnapshotTasks).map(c -> (ImportSnapshotTask)((ImportSnapshotTask.Builder)ImportSnapshotTask.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setImportSnapshotTasks(Collection<ImportSnapshotTask.BuilderImpl> importSnapshotTasks) {
            this.importSnapshotTasks = ImportSnapshotTaskListCopier.copyFromBuilder(importSnapshotTasks);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeImportSnapshotTasksResponse build() {
            return new DescribeImportSnapshotTasksResponse(this);
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    CopyableBuilder<Builder, DescribeImportSnapshotTasksResponse> {
        public Builder importSnapshotTasks(Collection<ImportSnapshotTask> var1);

        public Builder importSnapshotTasks(ImportSnapshotTask ... var1);

        public Builder importSnapshotTasks(Consumer<ImportSnapshotTask.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

