/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.FlowLogsResourceType;
import software.amazon.awssdk.services.ec2.model.TrafficType;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFlowLogsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateFlowLogsRequest> {
    private final String clientToken;
    private final String deliverLogsPermissionArn;
    private final String logGroupName;
    private final List<String> resourceIds;
    private final String resourceType;
    private final String trafficType;

    private CreateFlowLogsRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.deliverLogsPermissionArn = builder.deliverLogsPermissionArn;
        this.logGroupName = builder.logGroupName;
        this.resourceIds = builder.resourceIds;
        this.resourceType = builder.resourceType;
        this.trafficType = builder.trafficType;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public String deliverLogsPermissionArn() {
        return this.deliverLogsPermissionArn;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public List<String> resourceIds() {
        return this.resourceIds;
    }

    public FlowLogsResourceType resourceType() {
        return FlowLogsResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public TrafficType trafficType() {
        return TrafficType.fromValue(this.trafficType);
    }

    public String trafficTypeAsString() {
        return this.trafficType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliverLogsPermissionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFlowLogsRequest)) {
            return false;
        }
        CreateFlowLogsRequest other = (CreateFlowLogsRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.deliverLogsPermissionArn(), other.deliverLogsPermissionArn()) && Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.resourceIds(), other.resourceIds()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.trafficTypeAsString(), other.trafficTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"CreateFlowLogsRequest").add("ClientToken", (Object)this.clientToken()).add("DeliverLogsPermissionArn", (Object)this.deliverLogsPermissionArn()).add("LogGroupName", (Object)this.logGroupName()).add("ResourceIds", this.resourceIds()).add("ResourceType", (Object)this.resourceTypeAsString()).add("TrafficType", (Object)this.trafficTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "DeliverLogsPermissionArn": {
                return Optional.ofNullable(clazz.cast(this.deliverLogsPermissionArn()));
            }
            case "LogGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "ResourceIds": {
                return Optional.ofNullable(clazz.cast(this.resourceIds()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "TrafficType": {
                return Optional.ofNullable(clazz.cast(this.trafficTypeAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String clientToken;
        private String deliverLogsPermissionArn;
        private String logGroupName;
        private List<String> resourceIds = DefaultSdkAutoConstructList.getInstance();
        private String resourceType;
        private String trafficType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFlowLogsRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.deliverLogsPermissionArn(model.deliverLogsPermissionArn);
            this.logGroupName(model.logGroupName);
            this.resourceIds(model.resourceIds);
            this.resourceType(model.resourceType);
            this.trafficType(model.trafficType);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getDeliverLogsPermissionArn() {
            return this.deliverLogsPermissionArn;
        }

        @Override
        public final Builder deliverLogsPermissionArn(String deliverLogsPermissionArn) {
            this.deliverLogsPermissionArn = deliverLogsPermissionArn;
            return this;
        }

        public final void setDeliverLogsPermissionArn(String deliverLogsPermissionArn) {
            this.deliverLogsPermissionArn = deliverLogsPermissionArn;
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final Collection<String> getResourceIds() {
            return this.resourceIds;
        }

        @Override
        public final Builder resourceIds(Collection<String> resourceIds) {
            this.resourceIds = ValueStringListCopier.copy(resourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(String ... resourceIds) {
            this.resourceIds(Arrays.asList(resourceIds));
            return this;
        }

        public final void setResourceIds(Collection<String> resourceIds) {
            this.resourceIds = ValueStringListCopier.copy(resourceIds);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(FlowLogsResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getTrafficType() {
            return this.trafficType;
        }

        @Override
        public final Builder trafficType(String trafficType) {
            this.trafficType = trafficType;
            return this;
        }

        @Override
        public final Builder trafficType(TrafficType trafficType) {
            this.trafficType(trafficType.toString());
            return this;
        }

        public final void setTrafficType(String trafficType) {
            this.trafficType = trafficType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFlowLogsRequest build() {
            return new CreateFlowLogsRequest(this);
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    CopyableBuilder<Builder, CreateFlowLogsRequest> {
        public Builder clientToken(String var1);

        public Builder deliverLogsPermissionArn(String var1);

        public Builder logGroupName(String var1);

        public Builder resourceIds(Collection<String> var1);

        public Builder resourceIds(String ... var1);

        public Builder resourceType(String var1);

        public Builder resourceType(FlowLogsResourceType var1);

        public Builder trafficType(String var1);

        public Builder trafficType(TrafficType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

