/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.ModifyVolumeRequest;

public class ModifyVolumeRequestMarshaller
implements Marshaller<Request<ModifyVolumeRequest>, ModifyVolumeRequest> {
    public Request<ModifyVolumeRequest> marshall(ModifyVolumeRequest modifyVolumeRequest) {
        if (modifyVolumeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)modifyVolumeRequest, "EC2Client");
        request.addParameter("Action", "ModifyVolume");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyVolumeRequest.volumeId() != null) {
            request.addParameter("VolumeId", StringUtils.fromString((String)modifyVolumeRequest.volumeId()));
        }
        if (modifyVolumeRequest.size() != null) {
            request.addParameter("Size", StringUtils.fromInteger((Integer)modifyVolumeRequest.size()));
        }
        if (modifyVolumeRequest.volumeTypeAsString() != null) {
            request.addParameter("VolumeType", StringUtils.fromString((String)modifyVolumeRequest.volumeTypeAsString()));
        }
        if (modifyVolumeRequest.iops() != null) {
            request.addParameter("Iops", StringUtils.fromInteger((Integer)modifyVolumeRequest.iops()));
        }
        return request;
    }
}

