/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.CustomerGateway;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.transform.TagUnmarshaller;

public class CustomerGatewayUnmarshaller
implements Unmarshaller<CustomerGateway, StaxUnmarshallerContext> {
    private static final CustomerGatewayUnmarshaller INSTANCE = new CustomerGatewayUnmarshaller();

    public CustomerGateway unmarshall(StaxUnmarshallerContext context) throws Exception {
        CustomerGateway.Builder customerGateway;
        block10: {
            customerGateway = CustomerGateway.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<Tag> tags = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    customerGateway.tags(tags);
                    break block10;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("bgpAsn", targetDepth)) {
                        customerGateway.bgpAsn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("customerGatewayId", targetDepth)) {
                        customerGateway.customerGatewayId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ipAddress", targetDepth)) {
                        customerGateway.ipAddress(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("state", targetDepth)) {
                        customerGateway.state(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("type", targetDepth)) {
                        customerGateway.type(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("tagSet", targetDepth)) {
                        tags = new ArrayList<Tag>();
                        continue;
                    }
                    if (!context.testExpression("tagSet/item", targetDepth)) continue;
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            customerGateway.tags(tags);
        }
        return (CustomerGateway)customerGateway.build();
    }

    public static CustomerGatewayUnmarshaller getInstance() {
        return INSTANCE;
    }
}

