/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.ec2.model.VolumeStatusAction;
import software.amazon.awssdk.services.ec2.model.VolumeStatusActionsListCopier;
import software.amazon.awssdk.services.ec2.model.VolumeStatusEvent;
import software.amazon.awssdk.services.ec2.model.VolumeStatusEventsListCopier;
import software.amazon.awssdk.services.ec2.model.VolumeStatusInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VolumeStatusItem
implements ToCopyableBuilder<Builder, VolumeStatusItem> {
    private final List<VolumeStatusAction> actions;
    private final String availabilityZone;
    private final List<VolumeStatusEvent> events;
    private final String volumeId;
    private final VolumeStatusInfo volumeStatus;

    private VolumeStatusItem(BuilderImpl builder) {
        this.actions = builder.actions;
        this.availabilityZone = builder.availabilityZone;
        this.events = builder.events;
        this.volumeId = builder.volumeId;
        this.volumeStatus = builder.volumeStatus;
    }

    public List<VolumeStatusAction> actions() {
        return this.actions;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public List<VolumeStatusEvent> events() {
        return this.events;
    }

    public String volumeId() {
        return this.volumeId;
    }

    public VolumeStatusInfo volumeStatus() {
        return this.volumeStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actions());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.events());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeStatus());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeStatusItem)) {
            return false;
        }
        VolumeStatusItem other = (VolumeStatusItem)obj;
        return Objects.equals(this.actions(), other.actions()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.events(), other.events()) && Objects.equals(this.volumeId(), other.volumeId()) && Objects.equals(this.volumeStatus(), other.volumeStatus());
    }

    public String toString() {
        return ToString.builder((String)"VolumeStatusItem").add("Actions", this.actions()).add("AvailabilityZone", (Object)this.availabilityZone()).add("Events", this.events()).add("VolumeId", (Object)this.volumeId()).add("VolumeStatus", (Object)this.volumeStatus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Actions": {
                return Optional.of(clazz.cast(this.actions()));
            }
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "Events": {
                return Optional.of(clazz.cast(this.events()));
            }
            case "VolumeId": {
                return Optional.of(clazz.cast(this.volumeId()));
            }
            case "VolumeStatus": {
                return Optional.of(clazz.cast(this.volumeStatus()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<VolumeStatusAction> actions;
        private String availabilityZone;
        private List<VolumeStatusEvent> events;
        private String volumeId;
        private VolumeStatusInfo volumeStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeStatusItem model) {
            this.actions(model.actions);
            this.availabilityZone(model.availabilityZone);
            this.events(model.events);
            this.volumeId(model.volumeId);
            this.volumeStatus(model.volumeStatus);
        }

        public final Collection<VolumeStatusAction.Builder> getActions() {
            return this.actions != null ? (Collection)this.actions.stream().map(VolumeStatusAction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actions(Collection<VolumeStatusAction> actions) {
            this.actions = VolumeStatusActionsListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(VolumeStatusAction ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<VolumeStatusAction.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (VolumeStatusAction)((VolumeStatusAction.Builder)VolumeStatusAction.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActions(Collection<VolumeStatusAction.BuilderImpl> actions) {
            this.actions = VolumeStatusActionsListCopier.copyFromBuilder(actions);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Collection<VolumeStatusEvent.Builder> getEvents() {
            return this.events != null ? (Collection)this.events.stream().map(VolumeStatusEvent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder events(Collection<VolumeStatusEvent> events) {
            this.events = VolumeStatusEventsListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(VolumeStatusEvent ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<VolumeStatusEvent.Builder> ... events) {
            this.events(Stream.of(events).map(c -> (VolumeStatusEvent)((VolumeStatusEvent.Builder)VolumeStatusEvent.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEvents(Collection<VolumeStatusEvent.BuilderImpl> events) {
            this.events = VolumeStatusEventsListCopier.copyFromBuilder(events);
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public final VolumeStatusInfo.Builder getVolumeStatus() {
            return this.volumeStatus != null ? this.volumeStatus.toBuilder() : null;
        }

        @Override
        public final Builder volumeStatus(VolumeStatusInfo volumeStatus) {
            this.volumeStatus = volumeStatus;
            return this;
        }

        public final void setVolumeStatus(VolumeStatusInfo.BuilderImpl volumeStatus) {
            this.volumeStatus = volumeStatus != null ? volumeStatus.build() : null;
        }

        public VolumeStatusItem build() {
            return new VolumeStatusItem(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VolumeStatusItem> {
        public Builder actions(Collection<VolumeStatusAction> var1);

        public Builder actions(VolumeStatusAction ... var1);

        public Builder actions(Consumer<VolumeStatusAction.Builder> ... var1);

        public Builder availabilityZone(String var1);

        public Builder events(Collection<VolumeStatusEvent> var1);

        public Builder events(VolumeStatusEvent ... var1);

        public Builder events(Consumer<VolumeStatusEvent.Builder> ... var1);

        public Builder volumeId(String var1);

        public Builder volumeStatus(VolumeStatusInfo var1);

        default public Builder volumeStatus(Consumer<VolumeStatusInfo.Builder> volumeStatus) {
            return this.volumeStatus((VolumeStatusInfo)((VolumeStatusInfo.Builder)VolumeStatusInfo.builder().apply(volumeStatus)).build());
        }
    }
}

