/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.Affinity;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.HostTenancy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyInstancePlacementRequest
extends EC2Request
implements ToCopyableBuilder<Builder, ModifyInstancePlacementRequest> {
    private final String affinity;
    private final String hostId;
    private final String instanceId;
    private final String tenancy;

    private ModifyInstancePlacementRequest(BuilderImpl builder) {
        super(builder);
        this.affinity = builder.affinity;
        this.hostId = builder.hostId;
        this.instanceId = builder.instanceId;
        this.tenancy = builder.tenancy;
    }

    public Affinity affinity() {
        return Affinity.fromValue(this.affinity);
    }

    public String affinityAsString() {
        return this.affinity;
    }

    public String hostId() {
        return this.hostId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public HostTenancy tenancy() {
        return HostTenancy.fromValue(this.tenancy);
    }

    public String tenancyAsString() {
        return this.tenancy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.affinityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenancyAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstancePlacementRequest)) {
            return false;
        }
        ModifyInstancePlacementRequest other = (ModifyInstancePlacementRequest)((Object)obj);
        return Objects.equals(this.affinityAsString(), other.affinityAsString()) && Objects.equals(this.hostId(), other.hostId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.tenancyAsString(), other.tenancyAsString());
    }

    public String toString() {
        return ToString.builder((String)"ModifyInstancePlacementRequest").add("Affinity", (Object)this.affinityAsString()).add("HostId", (Object)this.hostId()).add("InstanceId", (Object)this.instanceId()).add("Tenancy", (Object)this.tenancyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Affinity": {
                return Optional.of(clazz.cast(this.affinityAsString()));
            }
            case "HostId": {
                return Optional.of(clazz.cast(this.hostId()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "Tenancy": {
                return Optional.of(clazz.cast(this.tenancyAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String affinity;
        private String hostId;
        private String instanceId;
        private String tenancy;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstancePlacementRequest model) {
            super(model);
            this.affinity(model.affinity);
            this.hostId(model.hostId);
            this.instanceId(model.instanceId);
            this.tenancy(model.tenancy);
        }

        public final String getAffinity() {
            return this.affinity;
        }

        @Override
        public final Builder affinity(String affinity) {
            this.affinity = affinity;
            return this;
        }

        @Override
        public final Builder affinity(Affinity affinity) {
            this.affinity(affinity.toString());
            return this;
        }

        public final void setAffinity(String affinity) {
            this.affinity = affinity;
        }

        public final String getHostId() {
            return this.hostId;
        }

        @Override
        public final Builder hostId(String hostId) {
            this.hostId = hostId;
            return this;
        }

        public final void setHostId(String hostId) {
            this.hostId = hostId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getTenancy() {
            return this.tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(HostTenancy tenancy) {
            this.tenancy(tenancy.toString());
            return this;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ModifyInstancePlacementRequest build() {
            return new ModifyInstancePlacementRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, ModifyInstancePlacementRequest> {
        public Builder affinity(String var1);

        public Builder affinity(Affinity var1);

        public Builder hostId(String var1);

        public Builder instanceId(String var1);

        public Builder tenancy(String var1);

        public Builder tenancy(HostTenancy var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

