/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImportKeyPairRequest
extends EC2Request
implements ToCopyableBuilder<Builder, ImportKeyPairRequest> {
    private final String keyName;
    private final String publicKeyMaterial;

    private ImportKeyPairRequest(BuilderImpl builder) {
        super(builder);
        this.keyName = builder.keyName;
        this.publicKeyMaterial = builder.publicKeyMaterial;
    }

    public String keyName() {
        return this.keyName;
    }

    public String publicKeyMaterial() {
        return this.publicKeyMaterial;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicKeyMaterial());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportKeyPairRequest)) {
            return false;
        }
        ImportKeyPairRequest other = (ImportKeyPairRequest)((Object)obj);
        return Objects.equals(this.keyName(), other.keyName()) && Objects.equals(this.publicKeyMaterial(), other.publicKeyMaterial());
    }

    public String toString() {
        return ToString.builder((String)"ImportKeyPairRequest").add("KeyName", (Object)this.keyName()).add("PublicKeyMaterial", (Object)this.publicKeyMaterial()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyName": {
                return Optional.of(clazz.cast(this.keyName()));
            }
            case "PublicKeyMaterial": {
                return Optional.of(clazz.cast(this.publicKeyMaterial()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String keyName;
        private String publicKeyMaterial;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportKeyPairRequest model) {
            super(model);
            this.keyName(model.keyName);
            this.publicKeyMaterial(model.publicKeyMaterial);
        }

        public final String getKeyName() {
            return this.keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final String getPublicKeyMaterial() {
            return this.publicKeyMaterial;
        }

        @Override
        public final Builder publicKeyMaterial(String publicKeyMaterial) {
            this.publicKeyMaterial = publicKeyMaterial;
            return this;
        }

        public final void setPublicKeyMaterial(String publicKeyMaterial) {
            this.publicKeyMaterial = publicKeyMaterial;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ImportKeyPairRequest build() {
            return new ImportKeyPairRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, ImportKeyPairRequest> {
        public Builder keyName(String var1);

        public Builder publicKeyMaterial(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

