/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.ReservedInstanceIdSetCopier;
import software.amazon.awssdk.services.ec2.model.TargetConfigurationRequest;
import software.amazon.awssdk.services.ec2.model.TargetConfigurationRequestSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetReservedInstancesExchangeQuoteRequest
extends EC2Request
implements ToCopyableBuilder<Builder, GetReservedInstancesExchangeQuoteRequest> {
    private final List<String> reservedInstanceIds;
    private final List<TargetConfigurationRequest> targetConfigurations;

    private GetReservedInstancesExchangeQuoteRequest(BuilderImpl builder) {
        super(builder);
        this.reservedInstanceIds = builder.reservedInstanceIds;
        this.targetConfigurations = builder.targetConfigurations;
    }

    public List<String> reservedInstanceIds() {
        return this.reservedInstanceIds;
    }

    public List<TargetConfigurationRequest> targetConfigurations() {
        return this.targetConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstanceIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetConfigurations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReservedInstancesExchangeQuoteRequest)) {
            return false;
        }
        GetReservedInstancesExchangeQuoteRequest other = (GetReservedInstancesExchangeQuoteRequest)((Object)obj);
        return Objects.equals(this.reservedInstanceIds(), other.reservedInstanceIds()) && Objects.equals(this.targetConfigurations(), other.targetConfigurations());
    }

    public String toString() {
        return ToString.builder((String)"GetReservedInstancesExchangeQuoteRequest").add("ReservedInstanceIds", this.reservedInstanceIds()).add("TargetConfigurations", this.targetConfigurations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedInstanceIds": {
                return Optional.of(clazz.cast(this.reservedInstanceIds()));
            }
            case "TargetConfigurations": {
                return Optional.of(clazz.cast(this.targetConfigurations()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private List<String> reservedInstanceIds;
        private List<TargetConfigurationRequest> targetConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReservedInstancesExchangeQuoteRequest model) {
            super(model);
            this.reservedInstanceIds(model.reservedInstanceIds);
            this.targetConfigurations(model.targetConfigurations);
        }

        public final Collection<String> getReservedInstanceIds() {
            return this.reservedInstanceIds;
        }

        @Override
        public final Builder reservedInstanceIds(Collection<String> reservedInstanceIds) {
            this.reservedInstanceIds = ReservedInstanceIdSetCopier.copy(reservedInstanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstanceIds(String ... reservedInstanceIds) {
            this.reservedInstanceIds(Arrays.asList(reservedInstanceIds));
            return this;
        }

        public final void setReservedInstanceIds(Collection<String> reservedInstanceIds) {
            this.reservedInstanceIds = ReservedInstanceIdSetCopier.copy(reservedInstanceIds);
        }

        public final Collection<TargetConfigurationRequest.Builder> getTargetConfigurations() {
            return this.targetConfigurations != null ? (Collection)this.targetConfigurations.stream().map(TargetConfigurationRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targetConfigurations(Collection<TargetConfigurationRequest> targetConfigurations) {
            this.targetConfigurations = TargetConfigurationRequestSetCopier.copy(targetConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetConfigurations(TargetConfigurationRequest ... targetConfigurations) {
            this.targetConfigurations(Arrays.asList(targetConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetConfigurations(Consumer<TargetConfigurationRequest.Builder> ... targetConfigurations) {
            this.targetConfigurations(Stream.of(targetConfigurations).map(c -> (TargetConfigurationRequest)((TargetConfigurationRequest.Builder)TargetConfigurationRequest.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargetConfigurations(Collection<TargetConfigurationRequest.BuilderImpl> targetConfigurations) {
            this.targetConfigurations = TargetConfigurationRequestSetCopier.copyFromBuilder(targetConfigurations);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetReservedInstancesExchangeQuoteRequest build() {
            return new GetReservedInstancesExchangeQuoteRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, GetReservedInstancesExchangeQuoteRequest> {
        public Builder reservedInstanceIds(Collection<String> var1);

        public Builder reservedInstanceIds(String ... var1);

        public Builder targetConfigurations(Collection<TargetConfigurationRequest> var1);

        public Builder targetConfigurations(TargetConfigurationRequest ... var1);

        public Builder targetConfigurations(Consumer<TargetConfigurationRequest.Builder> ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

