/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.services.ec2.model.Snapshot;
import software.amazon.awssdk.services.ec2.model.SnapshotListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSnapshotsResponse
extends EC2Response
implements ToCopyableBuilder<Builder, DescribeSnapshotsResponse> {
    private final List<Snapshot> snapshots;
    private final String nextToken;

    private DescribeSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.snapshots = builder.snapshots;
        this.nextToken = builder.nextToken;
    }

    public List<Snapshot> snapshots() {
        return this.snapshots;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshots());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotsResponse)) {
            return false;
        }
        DescribeSnapshotsResponse other = (DescribeSnapshotsResponse)((Object)obj);
        return Objects.equals(this.snapshots(), other.snapshots()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeSnapshotsResponse").add("Snapshots", this.snapshots()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Snapshots": {
                return Optional.of(clazz.cast(this.snapshots()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private List<Snapshot> snapshots;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotsResponse model) {
            super(model);
            this.snapshots(model.snapshots);
            this.nextToken(model.nextToken);
        }

        public final Collection<Snapshot.Builder> getSnapshots() {
            return this.snapshots != null ? (Collection)this.snapshots.stream().map(Snapshot::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder snapshots(Collection<Snapshot> snapshots) {
            this.snapshots = SnapshotListCopier.copy(snapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshots(Snapshot ... snapshots) {
            this.snapshots(Arrays.asList(snapshots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshots(Consumer<Snapshot.Builder> ... snapshots) {
            this.snapshots(Stream.of(snapshots).map(c -> (Snapshot)((Snapshot.Builder)Snapshot.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSnapshots(Collection<Snapshot.BuilderImpl> snapshots) {
            this.snapshots = SnapshotListCopier.copyFromBuilder(snapshots);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeSnapshotsResponse build() {
            return new DescribeSnapshotsResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, DescribeSnapshotsResponse> {
        public Builder snapshots(Collection<Snapshot> var1);

        public Builder snapshots(Snapshot ... var1);

        public Builder snapshots(Consumer<Snapshot.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

