/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateRouteRequest
extends EC2Request
implements ToCopyableBuilder<Builder, CreateRouteRequest> {
    private final String destinationCidrBlock;
    private final String destinationIpv6CidrBlock;
    private final String egressOnlyInternetGatewayId;
    private final String gatewayId;
    private final String instanceId;
    private final String natGatewayId;
    private final String networkInterfaceId;
    private final String routeTableId;
    private final String vpcPeeringConnectionId;

    private CreateRouteRequest(BuilderImpl builder) {
        super(builder);
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.destinationIpv6CidrBlock = builder.destinationIpv6CidrBlock;
        this.egressOnlyInternetGatewayId = builder.egressOnlyInternetGatewayId;
        this.gatewayId = builder.gatewayId;
        this.instanceId = builder.instanceId;
        this.natGatewayId = builder.natGatewayId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.routeTableId = builder.routeTableId;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
    }

    public String destinationCidrBlock() {
        return this.destinationCidrBlock;
    }

    public String destinationIpv6CidrBlock() {
        return this.destinationIpv6CidrBlock;
    }

    public String egressOnlyInternetGatewayId() {
        return this.egressOnlyInternetGatewayId;
    }

    public String gatewayId() {
        return this.gatewayId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String natGatewayId() {
        return this.natGatewayId;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public String routeTableId() {
        return this.routeTableId;
    }

    public String vpcPeeringConnectionId() {
        return this.vpcPeeringConnectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationIpv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.egressOnlyInternetGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.natGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcPeeringConnectionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRouteRequest)) {
            return false;
        }
        CreateRouteRequest other = (CreateRouteRequest)((Object)obj);
        return Objects.equals(this.destinationCidrBlock(), other.destinationCidrBlock()) && Objects.equals(this.destinationIpv6CidrBlock(), other.destinationIpv6CidrBlock()) && Objects.equals(this.egressOnlyInternetGatewayId(), other.egressOnlyInternetGatewayId()) && Objects.equals(this.gatewayId(), other.gatewayId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.natGatewayId(), other.natGatewayId()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.routeTableId(), other.routeTableId()) && Objects.equals(this.vpcPeeringConnectionId(), other.vpcPeeringConnectionId());
    }

    public String toString() {
        return ToString.builder((String)"CreateRouteRequest").add("DestinationCidrBlock", (Object)this.destinationCidrBlock()).add("DestinationIpv6CidrBlock", (Object)this.destinationIpv6CidrBlock()).add("EgressOnlyInternetGatewayId", (Object)this.egressOnlyInternetGatewayId()).add("GatewayId", (Object)this.gatewayId()).add("InstanceId", (Object)this.instanceId()).add("NatGatewayId", (Object)this.natGatewayId()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("RouteTableId", (Object)this.routeTableId()).add("VpcPeeringConnectionId", (Object)this.vpcPeeringConnectionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationCidrBlock": {
                return Optional.of(clazz.cast(this.destinationCidrBlock()));
            }
            case "DestinationIpv6CidrBlock": {
                return Optional.of(clazz.cast(this.destinationIpv6CidrBlock()));
            }
            case "EgressOnlyInternetGatewayId": {
                return Optional.of(clazz.cast(this.egressOnlyInternetGatewayId()));
            }
            case "GatewayId": {
                return Optional.of(clazz.cast(this.gatewayId()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "NatGatewayId": {
                return Optional.of(clazz.cast(this.natGatewayId()));
            }
            case "NetworkInterfaceId": {
                return Optional.of(clazz.cast(this.networkInterfaceId()));
            }
            case "RouteTableId": {
                return Optional.of(clazz.cast(this.routeTableId()));
            }
            case "VpcPeeringConnectionId": {
                return Optional.of(clazz.cast(this.vpcPeeringConnectionId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String destinationCidrBlock;
        private String destinationIpv6CidrBlock;
        private String egressOnlyInternetGatewayId;
        private String gatewayId;
        private String instanceId;
        private String natGatewayId;
        private String networkInterfaceId;
        private String routeTableId;
        private String vpcPeeringConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRouteRequest model) {
            super(model);
            this.destinationCidrBlock(model.destinationCidrBlock);
            this.destinationIpv6CidrBlock(model.destinationIpv6CidrBlock);
            this.egressOnlyInternetGatewayId(model.egressOnlyInternetGatewayId);
            this.gatewayId(model.gatewayId);
            this.instanceId(model.instanceId);
            this.natGatewayId(model.natGatewayId);
            this.networkInterfaceId(model.networkInterfaceId);
            this.routeTableId(model.routeTableId);
            this.vpcPeeringConnectionId(model.vpcPeeringConnectionId);
        }

        public final String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        public final String getDestinationIpv6CidrBlock() {
            return this.destinationIpv6CidrBlock;
        }

        @Override
        public final Builder destinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
            return this;
        }

        public final void setDestinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
        }

        public final String getEgressOnlyInternetGatewayId() {
            return this.egressOnlyInternetGatewayId;
        }

        @Override
        public final Builder egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
            return this;
        }

        public final void setEgressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
        }

        public final String getGatewayId() {
            return this.gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getNatGatewayId() {
            return this.natGatewayId;
        }

        @Override
        public final Builder natGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        public final void setNatGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getRouteTableId() {
            return this.routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        public final String getVpcPeeringConnectionId() {
            return this.vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateRouteRequest build() {
            return new CreateRouteRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, CreateRouteRequest> {
        public Builder destinationCidrBlock(String var1);

        public Builder destinationIpv6CidrBlock(String var1);

        public Builder egressOnlyInternetGatewayId(String var1);

        public Builder gatewayId(String var1);

        public Builder instanceId(String var1);

        public Builder natGatewayId(String var1);

        public Builder networkInterfaceId(String var1);

        public Builder routeTableId(String var1);

        public Builder vpcPeeringConnectionId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

