/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.VpcPeeringConnection;
import software.amazon.awssdk.services.ec2.transform.TagUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.VpcPeeringConnectionStateReasonUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.VpcPeeringConnectionVpcInfoUnmarshaller;

public class VpcPeeringConnectionUnmarshaller
implements Unmarshaller<VpcPeeringConnection, StaxUnmarshallerContext> {
    private static VpcPeeringConnectionUnmarshaller INSTANCE;

    public VpcPeeringConnection unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        VpcPeeringConnection.Builder vpcPeeringConnection = VpcPeeringConnection.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("accepterVpcInfo", targetDepth)) {
                    vpcPeeringConnection.accepterVpcInfo(VpcPeeringConnectionVpcInfoUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("expirationTime", targetDepth)) {
                    vpcPeeringConnection.expirationTime(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("requesterVpcInfo", targetDepth)) {
                    vpcPeeringConnection.requesterVpcInfo(VpcPeeringConnectionVpcInfoUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("status", targetDepth)) {
                    vpcPeeringConnection.status(VpcPeeringConnectionStateReasonUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("tagSet", targetDepth)) {
                    vpcPeeringConnection.tags(new ArrayList<Tag>());
                    continue;
                }
                if (context.testExpression("tagSet/item", targetDepth)) {
                    vpcPeeringConnection.tags(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("vpcPeeringConnectionId", targetDepth)) continue;
                vpcPeeringConnection.vpcPeeringConnectionId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (VpcPeeringConnection)vpcPeeringConnection.build();
    }

    public static VpcPeeringConnectionUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new VpcPeeringConnectionUnmarshaller();
        }
        return INSTANCE;
    }
}

