/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.VpcEndpoint;

public class VpcEndpointUnmarshaller
implements Unmarshaller<VpcEndpoint, StaxUnmarshallerContext> {
    private static VpcEndpointUnmarshaller INSTANCE;

    public VpcEndpoint unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        VpcEndpoint.Builder vpcEndpoint = VpcEndpoint.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("creationTimestamp", targetDepth)) {
                    vpcEndpoint.creationTimestamp(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("policyDocument", targetDepth)) {
                    vpcEndpoint.policyDocument(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("routeTableIdSet", targetDepth)) {
                    vpcEndpoint.routeTableIds(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("routeTableIdSet/item", targetDepth)) {
                    vpcEndpoint.routeTableIds(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("serviceName", targetDepth)) {
                    vpcEndpoint.serviceName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("state", targetDepth)) {
                    vpcEndpoint.state(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("vpcEndpointId", targetDepth)) {
                    vpcEndpoint.vpcEndpointId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("vpcId", targetDepth)) continue;
                vpcEndpoint.vpcId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (VpcEndpoint)vpcEndpoint.build();
    }

    public static VpcEndpointUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new VpcEndpointUnmarshaller();
        }
        return INSTANCE;
    }
}

