/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.IpPermission;
import software.amazon.awssdk.services.ec2.model.SecurityGroup;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.transform.IpPermissionUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.TagUnmarshaller;

public class SecurityGroupUnmarshaller
implements Unmarshaller<SecurityGroup, StaxUnmarshallerContext> {
    private static SecurityGroupUnmarshaller INSTANCE;

    public SecurityGroup unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        SecurityGroup.Builder securityGroup = SecurityGroup.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("groupDescription", targetDepth)) {
                    securityGroup.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("groupName", targetDepth)) {
                    securityGroup.groupName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ipPermissions", targetDepth)) {
                    securityGroup.ipPermissions(new ArrayList<IpPermission>());
                    continue;
                }
                if (context.testExpression("ipPermissions/item", targetDepth)) {
                    securityGroup.ipPermissions(IpPermissionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ownerId", targetDepth)) {
                    securityGroup.ownerId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("groupId", targetDepth)) {
                    securityGroup.groupId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ipPermissionsEgress", targetDepth)) {
                    securityGroup.ipPermissionsEgress(new ArrayList<IpPermission>());
                    continue;
                }
                if (context.testExpression("ipPermissionsEgress/item", targetDepth)) {
                    securityGroup.ipPermissionsEgress(IpPermissionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("tagSet", targetDepth)) {
                    securityGroup.tags(new ArrayList<Tag>());
                    continue;
                }
                if (context.testExpression("tagSet/item", targetDepth)) {
                    securityGroup.tags(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("vpcId", targetDepth)) continue;
                securityGroup.vpcId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (SecurityGroup)securityGroup.build();
    }

    public static SecurityGroupUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SecurityGroupUnmarshaller();
        }
        return INSTANCE;
    }
}

