/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.Date;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.EbsBlockDevice;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfileSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceIpv6Address;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecification;
import software.amazon.awssdk.services.ec2.model.PrivateIpAddressSpecification;
import software.amazon.awssdk.services.ec2.model.RequestSpotFleetRequest;
import software.amazon.awssdk.services.ec2.model.SpotFleetLaunchSpecification;
import software.amazon.awssdk.services.ec2.model.SpotFleetMonitoring;
import software.amazon.awssdk.services.ec2.model.SpotFleetRequestConfigData;
import software.amazon.awssdk.services.ec2.model.SpotPlacement;
import software.amazon.awssdk.util.StringUtils;

public class RequestSpotFleetRequestMarshaller
implements Marshaller<Request<RequestSpotFleetRequest>, RequestSpotFleetRequest> {
    public Request<RequestSpotFleetRequest> marshall(RequestSpotFleetRequest requestSpotFleetRequest) {
        if (requestSpotFleetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)requestSpotFleetRequest, "EC2Client");
        request.addParameter("Action", "RequestSpotFleet");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SpotFleetRequestConfigData spotFleetRequestConfig = requestSpotFleetRequest.spotFleetRequestConfig();
        if (spotFleetRequestConfig != null) {
            SdkInternalList spotFleetRequestConfigDataLaunchSpecificationsList;
            if (spotFleetRequestConfig.allocationStrategy() != null) {
                request.addParameter("SpotFleetRequestConfig.AllocationStrategy", StringUtils.fromString((String)spotFleetRequestConfig.allocationStrategy()));
            }
            if (spotFleetRequestConfig.clientToken() != null) {
                request.addParameter("SpotFleetRequestConfig.ClientToken", StringUtils.fromString((String)spotFleetRequestConfig.clientToken()));
            }
            if (spotFleetRequestConfig.excessCapacityTerminationPolicy() != null) {
                request.addParameter("SpotFleetRequestConfig.ExcessCapacityTerminationPolicy", StringUtils.fromString((String)spotFleetRequestConfig.excessCapacityTerminationPolicy()));
            }
            if (spotFleetRequestConfig.fulfilledCapacity() != null) {
                request.addParameter("SpotFleetRequestConfig.FulfilledCapacity", StringUtils.fromDouble((Double)spotFleetRequestConfig.fulfilledCapacity()));
            }
            if (spotFleetRequestConfig.iamFleetRole() != null) {
                request.addParameter("SpotFleetRequestConfig.IamFleetRole", StringUtils.fromString((String)spotFleetRequestConfig.iamFleetRole()));
            }
            if (!(spotFleetRequestConfigDataLaunchSpecificationsList = (SdkInternalList)spotFleetRequestConfig.launchSpecifications()).isEmpty() || !spotFleetRequestConfigDataLaunchSpecificationsList.isAutoConstruct()) {
                int launchSpecificationsListIndex = 1;
                for (SpotFleetLaunchSpecification spotFleetRequestConfigDataLaunchSpecificationsListValue : spotFleetRequestConfigDataLaunchSpecificationsList) {
                    SpotPlacement placement;
                    SdkInternalList spotFleetLaunchSpecificationNetworkInterfacesList;
                    SpotFleetMonitoring monitoring;
                    IamInstanceProfileSpecification iamInstanceProfile;
                    SdkInternalList spotFleetLaunchSpecificationBlockDeviceMappingsList;
                    SdkInternalList spotFleetLaunchSpecificationSecurityGroupsList = (SdkInternalList)spotFleetRequestConfigDataLaunchSpecificationsListValue.securityGroups();
                    if (!spotFleetLaunchSpecificationSecurityGroupsList.isEmpty() || !spotFleetLaunchSpecificationSecurityGroupsList.isAutoConstruct()) {
                        int securityGroupsListIndex = 1;
                        for (Object spotFleetLaunchSpecificationSecurityGroupsListValue : spotFleetLaunchSpecificationSecurityGroupsList) {
                            if (((GroupIdentifier)spotFleetLaunchSpecificationSecurityGroupsListValue).groupName() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".GroupSet." + securityGroupsListIndex + ".GroupName", StringUtils.fromString((String)((GroupIdentifier)spotFleetLaunchSpecificationSecurityGroupsListValue).groupName()));
                            }
                            if (((GroupIdentifier)spotFleetLaunchSpecificationSecurityGroupsListValue).groupId() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".GroupSet." + securityGroupsListIndex + ".GroupId", StringUtils.fromString((String)((GroupIdentifier)spotFleetLaunchSpecificationSecurityGroupsListValue).groupId()));
                            }
                            ++securityGroupsListIndex;
                        }
                    }
                    if (spotFleetRequestConfigDataLaunchSpecificationsListValue.addressingType() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".AddressingType", StringUtils.fromString((String)spotFleetRequestConfigDataLaunchSpecificationsListValue.addressingType()));
                    }
                    if (!(spotFleetLaunchSpecificationBlockDeviceMappingsList = (SdkInternalList)spotFleetRequestConfigDataLaunchSpecificationsListValue.blockDeviceMappings()).isEmpty() || !spotFleetLaunchSpecificationBlockDeviceMappingsList.isAutoConstruct()) {
                        Object spotFleetLaunchSpecificationSecurityGroupsListValue;
                        int blockDeviceMappingsListIndex = 1;
                        spotFleetLaunchSpecificationSecurityGroupsListValue = spotFleetLaunchSpecificationBlockDeviceMappingsList.iterator();
                        while (spotFleetLaunchSpecificationSecurityGroupsListValue.hasNext()) {
                            EbsBlockDevice ebs;
                            BlockDeviceMapping spotFleetLaunchSpecificationBlockDeviceMappingsListValue = (BlockDeviceMapping)spotFleetLaunchSpecificationSecurityGroupsListValue.next();
                            if (spotFleetLaunchSpecificationBlockDeviceMappingsListValue.deviceName() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString((String)spotFleetLaunchSpecificationBlockDeviceMappingsListValue.deviceName()));
                            }
                            if (spotFleetLaunchSpecificationBlockDeviceMappingsListValue.virtualName() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString((String)spotFleetLaunchSpecificationBlockDeviceMappingsListValue.virtualName()));
                            }
                            if ((ebs = spotFleetLaunchSpecificationBlockDeviceMappingsListValue.ebs()) != null) {
                                if (ebs.encrypted() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringUtils.fromBoolean((Boolean)ebs.encrypted()));
                                }
                                if (ebs.deleteOnTermination() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean((Boolean)ebs.deleteOnTermination()));
                                }
                                if (ebs.iops() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringUtils.fromInteger((Integer)ebs.iops()));
                                }
                                if (ebs.snapshotId() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString((String)ebs.snapshotId()));
                                }
                                if (ebs.volumeSize() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger((Integer)ebs.volumeSize()));
                                }
                                if (ebs.volumeType() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringUtils.fromString((String)ebs.volumeType()));
                                }
                            }
                            if (spotFleetLaunchSpecificationBlockDeviceMappingsListValue.noDevice() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString((String)spotFleetLaunchSpecificationBlockDeviceMappingsListValue.noDevice()));
                            }
                            ++blockDeviceMappingsListIndex;
                        }
                    }
                    if (spotFleetRequestConfigDataLaunchSpecificationsListValue.ebsOptimized() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".EbsOptimized", StringUtils.fromBoolean((Boolean)spotFleetRequestConfigDataLaunchSpecificationsListValue.ebsOptimized()));
                    }
                    if ((iamInstanceProfile = spotFleetRequestConfigDataLaunchSpecificationsListValue.iamInstanceProfile()) != null) {
                        if (iamInstanceProfile.arn() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".IamInstanceProfile.Arn", StringUtils.fromString((String)iamInstanceProfile.arn()));
                        }
                        if (iamInstanceProfile.name() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".IamInstanceProfile.Name", StringUtils.fromString((String)iamInstanceProfile.name()));
                        }
                    }
                    if (spotFleetRequestConfigDataLaunchSpecificationsListValue.imageId() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".ImageId", StringUtils.fromString((String)spotFleetRequestConfigDataLaunchSpecificationsListValue.imageId()));
                    }
                    if (spotFleetRequestConfigDataLaunchSpecificationsListValue.instanceType() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceType", StringUtils.fromString((String)spotFleetRequestConfigDataLaunchSpecificationsListValue.instanceType()));
                    }
                    if (spotFleetRequestConfigDataLaunchSpecificationsListValue.kernelId() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".KernelId", StringUtils.fromString((String)spotFleetRequestConfigDataLaunchSpecificationsListValue.kernelId()));
                    }
                    if (spotFleetRequestConfigDataLaunchSpecificationsListValue.keyName() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".KeyName", StringUtils.fromString((String)spotFleetRequestConfigDataLaunchSpecificationsListValue.keyName()));
                    }
                    if ((monitoring = spotFleetRequestConfigDataLaunchSpecificationsListValue.monitoring()) != null && monitoring.enabled() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".Monitoring.Enabled", StringUtils.fromBoolean((Boolean)monitoring.enabled()));
                    }
                    if (!(spotFleetLaunchSpecificationNetworkInterfacesList = (SdkInternalList)spotFleetRequestConfigDataLaunchSpecificationsListValue.networkInterfaces()).isEmpty() || !spotFleetLaunchSpecificationNetworkInterfacesList.isAutoConstruct()) {
                        int networkInterfacesListIndex = 1;
                        for (InstanceNetworkInterfaceSpecification spotFleetLaunchSpecificationNetworkInterfacesListValue : spotFleetLaunchSpecificationNetworkInterfacesList) {
                            SdkInternalList instanceNetworkInterfaceSpecificationPrivateIpAddressesList;
                            SdkInternalList instanceNetworkInterfaceSpecificationIpv6AddressesList;
                            SdkInternalList instanceNetworkInterfaceSpecificationGroupsList;
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.associatePublicIpAddress() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".AssociatePublicIpAddress", StringUtils.fromBoolean((Boolean)spotFleetLaunchSpecificationNetworkInterfacesListValue.associatePublicIpAddress()));
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.deleteOnTermination() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".DeleteOnTermination", StringUtils.fromBoolean((Boolean)spotFleetLaunchSpecificationNetworkInterfacesListValue.deleteOnTermination()));
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.description() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".Description", StringUtils.fromString((String)spotFleetLaunchSpecificationNetworkInterfacesListValue.description()));
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.deviceIndex() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".DeviceIndex", StringUtils.fromInteger((Integer)spotFleetLaunchSpecificationNetworkInterfacesListValue.deviceIndex()));
                            }
                            if (!(instanceNetworkInterfaceSpecificationGroupsList = (SdkInternalList)spotFleetLaunchSpecificationNetworkInterfacesListValue.groups()).isEmpty() || !instanceNetworkInterfaceSpecificationGroupsList.isAutoConstruct()) {
                                int groupsListIndex = 1;
                                for (Object instanceNetworkInterfaceSpecificationGroupsListValue : instanceNetworkInterfaceSpecificationGroupsList) {
                                    if (instanceNetworkInterfaceSpecificationGroupsListValue != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".SecurityGroupId." + groupsListIndex, StringUtils.fromString((String)instanceNetworkInterfaceSpecificationGroupsListValue));
                                    }
                                    ++groupsListIndex;
                                }
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.ipv6AddressCount() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".Ipv6AddressCount", StringUtils.fromInteger((Integer)spotFleetLaunchSpecificationNetworkInterfacesListValue.ipv6AddressCount()));
                            }
                            if (!(instanceNetworkInterfaceSpecificationIpv6AddressesList = (SdkInternalList)spotFleetLaunchSpecificationNetworkInterfacesListValue.ipv6Addresses()).isEmpty() || !instanceNetworkInterfaceSpecificationIpv6AddressesList.isAutoConstruct()) {
                                Object instanceNetworkInterfaceSpecificationGroupsListValue;
                                int ipv6AddressesListIndex = 1;
                                instanceNetworkInterfaceSpecificationGroupsListValue = instanceNetworkInterfaceSpecificationIpv6AddressesList.iterator();
                                while (instanceNetworkInterfaceSpecificationGroupsListValue.hasNext()) {
                                    InstanceIpv6Address instanceNetworkInterfaceSpecificationIpv6AddressesListValue = (InstanceIpv6Address)instanceNetworkInterfaceSpecificationGroupsListValue.next();
                                    if (instanceNetworkInterfaceSpecificationIpv6AddressesListValue.ipv6Address() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".Ipv6Addresses." + ipv6AddressesListIndex + ".Ipv6Address", StringUtils.fromString((String)instanceNetworkInterfaceSpecificationIpv6AddressesListValue.ipv6Address()));
                                    }
                                    ++ipv6AddressesListIndex;
                                }
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.networkInterfaceId() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".NetworkInterfaceId", StringUtils.fromString((String)spotFleetLaunchSpecificationNetworkInterfacesListValue.networkInterfaceId()));
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.privateIpAddress() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)spotFleetLaunchSpecificationNetworkInterfacesListValue.privateIpAddress()));
                            }
                            if (!(instanceNetworkInterfaceSpecificationPrivateIpAddressesList = (SdkInternalList)spotFleetLaunchSpecificationNetworkInterfacesListValue.privateIpAddresses()).isEmpty() || !instanceNetworkInterfaceSpecificationPrivateIpAddressesList.isAutoConstruct()) {
                                int privateIpAddressesListIndex = 1;
                                for (PrivateIpAddressSpecification instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue : instanceNetworkInterfaceSpecificationPrivateIpAddressesList) {
                                    if (instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.primary() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".Primary", StringUtils.fromBoolean((Boolean)instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.primary()));
                                    }
                                    if (instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.privateIpAddress() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.privateIpAddress()));
                                    }
                                    ++privateIpAddressesListIndex;
                                }
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.secondaryPrivateIpAddressCount() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".SecondaryPrivateIpAddressCount", StringUtils.fromInteger((Integer)spotFleetLaunchSpecificationNetworkInterfacesListValue.secondaryPrivateIpAddressCount()));
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.subnetId() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".SubnetId", StringUtils.fromString((String)spotFleetLaunchSpecificationNetworkInterfacesListValue.subnetId()));
                            }
                            ++networkInterfacesListIndex;
                        }
                    }
                    if ((placement = spotFleetRequestConfigDataLaunchSpecificationsListValue.placement()) != null) {
                        if (placement.availabilityZone() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".Placement.AvailabilityZone", StringUtils.fromString((String)placement.availabilityZone()));
                        }
                        if (placement.groupName() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".Placement.GroupName", StringUtils.fromString((String)placement.groupName()));
                        }
                        if (placement.tenancy() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".Placement.Tenancy", StringUtils.fromString((String)placement.tenancy()));
                        }
                    }
                    if (spotFleetRequestConfigDataLaunchSpecificationsListValue.ramdiskId() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".RamdiskId", StringUtils.fromString((String)spotFleetRequestConfigDataLaunchSpecificationsListValue.ramdiskId()));
                    }
                    if (spotFleetRequestConfigDataLaunchSpecificationsListValue.spotPrice() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".SpotPrice", StringUtils.fromString((String)spotFleetRequestConfigDataLaunchSpecificationsListValue.spotPrice()));
                    }
                    if (spotFleetRequestConfigDataLaunchSpecificationsListValue.subnetId() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".SubnetId", StringUtils.fromString((String)spotFleetRequestConfigDataLaunchSpecificationsListValue.subnetId()));
                    }
                    if (spotFleetRequestConfigDataLaunchSpecificationsListValue.userData() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".UserData", StringUtils.fromString((String)spotFleetRequestConfigDataLaunchSpecificationsListValue.userData()));
                    }
                    if (spotFleetRequestConfigDataLaunchSpecificationsListValue.weightedCapacity() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".WeightedCapacity", StringUtils.fromDouble((Double)spotFleetRequestConfigDataLaunchSpecificationsListValue.weightedCapacity()));
                    }
                    ++launchSpecificationsListIndex;
                }
            }
            if (spotFleetRequestConfig.spotPrice() != null) {
                request.addParameter("SpotFleetRequestConfig.SpotPrice", StringUtils.fromString((String)spotFleetRequestConfig.spotPrice()));
            }
            if (spotFleetRequestConfig.targetCapacity() != null) {
                request.addParameter("SpotFleetRequestConfig.TargetCapacity", StringUtils.fromInteger((Integer)spotFleetRequestConfig.targetCapacity()));
            }
            if (spotFleetRequestConfig.terminateInstancesWithExpiration() != null) {
                request.addParameter("SpotFleetRequestConfig.TerminateInstancesWithExpiration", StringUtils.fromBoolean((Boolean)spotFleetRequestConfig.terminateInstancesWithExpiration()));
            }
            if (spotFleetRequestConfig.type() != null) {
                request.addParameter("SpotFleetRequestConfig.Type", StringUtils.fromString((String)spotFleetRequestConfig.type()));
            }
            if (spotFleetRequestConfig.validFrom() != null) {
                request.addParameter("SpotFleetRequestConfig.ValidFrom", StringUtils.fromDate((Date)spotFleetRequestConfig.validFrom()));
            }
            if (spotFleetRequestConfig.validUntil() != null) {
                request.addParameter("SpotFleetRequestConfig.ValidUntil", StringUtils.fromDate((Date)spotFleetRequestConfig.validUntil()));
            }
            if (spotFleetRequestConfig.replaceUnhealthyInstances() != null) {
                request.addParameter("SpotFleetRequestConfig.ReplaceUnhealthyInstances", StringUtils.fromBoolean((Boolean)spotFleetRequestConfig.replaceUnhealthyInstances()));
            }
        }
        return request;
    }
}

