/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.Date;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.ReportInstanceStatusRequest;
import software.amazon.awssdk.util.StringUtils;

public class ReportInstanceStatusRequestMarshaller
implements Marshaller<Request<ReportInstanceStatusRequest>, ReportInstanceStatusRequest> {
    public Request<ReportInstanceStatusRequest> marshall(ReportInstanceStatusRequest reportInstanceStatusRequest) {
        SdkInternalList reportInstanceStatusRequestReasonCodesList;
        SdkInternalList reportInstanceStatusRequestInstancesList;
        if (reportInstanceStatusRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)reportInstanceStatusRequest, "EC2Client");
        request.addParameter("Action", "ReportInstanceStatus");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (reportInstanceStatusRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)reportInstanceStatusRequest.description()));
        }
        if (reportInstanceStatusRequest.endTime() != null) {
            request.addParameter("EndTime", StringUtils.fromDate((Date)reportInstanceStatusRequest.endTime()));
        }
        if (!(reportInstanceStatusRequestInstancesList = (SdkInternalList)reportInstanceStatusRequest.instances()).isEmpty() || !reportInstanceStatusRequestInstancesList.isAutoConstruct()) {
            int instancesListIndex = 1;
            for (String reportInstanceStatusRequestInstancesListValue : reportInstanceStatusRequestInstancesList) {
                if (reportInstanceStatusRequestInstancesListValue != null) {
                    request.addParameter("InstanceId." + instancesListIndex, StringUtils.fromString((String)reportInstanceStatusRequestInstancesListValue));
                }
                ++instancesListIndex;
            }
        }
        if (!(reportInstanceStatusRequestReasonCodesList = (SdkInternalList)reportInstanceStatusRequest.reasonCodes()).isEmpty() || !reportInstanceStatusRequestReasonCodesList.isAutoConstruct()) {
            int reasonCodesListIndex = 1;
            for (String reportInstanceStatusRequestReasonCodesListValue : reportInstanceStatusRequestReasonCodesList) {
                if (reportInstanceStatusRequestReasonCodesListValue != null) {
                    request.addParameter("ReasonCode." + reasonCodesListIndex, StringUtils.fromString((String)reportInstanceStatusRequestReasonCodesListValue));
                }
                ++reasonCodesListIndex;
            }
        }
        if (reportInstanceStatusRequest.startTime() != null) {
            request.addParameter("StartTime", StringUtils.fromDate((Date)reportInstanceStatusRequest.startTime()));
        }
        if (reportInstanceStatusRequest.status() != null) {
            request.addParameter("Status", StringUtils.fromString((String)reportInstanceStatusRequest.status()));
        }
        return request;
    }
}

