/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.EbsInstanceBlockDeviceSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMappingSpecification;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceAttributeRequest;
import software.amazon.awssdk.util.StringUtils;

public class ModifyInstanceAttributeRequestMarshaller
implements Marshaller<Request<ModifyInstanceAttributeRequest>, ModifyInstanceAttributeRequest> {
    public Request<ModifyInstanceAttributeRequest> marshall(ModifyInstanceAttributeRequest modifyInstanceAttributeRequest) {
        SdkInternalList modifyInstanceAttributeRequestGroupsList;
        SdkInternalList modifyInstanceAttributeRequestBlockDeviceMappingsList;
        if (modifyInstanceAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyInstanceAttributeRequest, "EC2Client");
        request.addParameter("Action", "ModifyInstanceAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyInstanceAttributeRequest.sourceDestCheck() != null) {
            request.addParameter("SourceDestCheck.Value", StringUtils.fromBoolean((Boolean)modifyInstanceAttributeRequest.sourceDestCheck()));
        }
        if (modifyInstanceAttributeRequest.attribute() != null) {
            request.addParameter("Attribute", StringUtils.fromString((String)modifyInstanceAttributeRequest.attribute()));
        }
        if (!(modifyInstanceAttributeRequestBlockDeviceMappingsList = (SdkInternalList)modifyInstanceAttributeRequest.blockDeviceMappings()).isEmpty() || !modifyInstanceAttributeRequestBlockDeviceMappingsList.isAutoConstruct()) {
            int blockDeviceMappingsListIndex = 1;
            for (InstanceBlockDeviceMappingSpecification modifyInstanceAttributeRequestBlockDeviceMappingsListValue : modifyInstanceAttributeRequestBlockDeviceMappingsList) {
                EbsInstanceBlockDeviceSpecification ebs;
                if (modifyInstanceAttributeRequestBlockDeviceMappingsListValue.deviceName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString((String)modifyInstanceAttributeRequestBlockDeviceMappingsListValue.deviceName()));
                }
                if ((ebs = modifyInstanceAttributeRequestBlockDeviceMappingsListValue.ebs()) != null) {
                    if (ebs.deleteOnTermination() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean((Boolean)ebs.deleteOnTermination()));
                    }
                    if (ebs.volumeId() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeId", StringUtils.fromString((String)ebs.volumeId()));
                    }
                }
                if (modifyInstanceAttributeRequestBlockDeviceMappingsListValue.noDevice() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString((String)modifyInstanceAttributeRequestBlockDeviceMappingsListValue.noDevice()));
                }
                if (modifyInstanceAttributeRequestBlockDeviceMappingsListValue.virtualName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString((String)modifyInstanceAttributeRequestBlockDeviceMappingsListValue.virtualName()));
                }
                ++blockDeviceMappingsListIndex;
            }
        }
        if (modifyInstanceAttributeRequest.disableApiTermination() != null) {
            request.addParameter("DisableApiTermination.Value", StringUtils.fromBoolean((Boolean)modifyInstanceAttributeRequest.disableApiTermination()));
        }
        if (modifyInstanceAttributeRequest.ebsOptimized() != null) {
            request.addParameter("EbsOptimized.Value", StringUtils.fromBoolean((Boolean)modifyInstanceAttributeRequest.ebsOptimized()));
        }
        if (modifyInstanceAttributeRequest.enaSupport() != null) {
            request.addParameter("EnaSupport.Value", StringUtils.fromBoolean((Boolean)modifyInstanceAttributeRequest.enaSupport()));
        }
        if (!(modifyInstanceAttributeRequestGroupsList = (SdkInternalList)modifyInstanceAttributeRequest.groups()).isEmpty() || !modifyInstanceAttributeRequestGroupsList.isAutoConstruct()) {
            int groupsListIndex = 1;
            for (String modifyInstanceAttributeRequestGroupsListValue : modifyInstanceAttributeRequestGroupsList) {
                if (modifyInstanceAttributeRequestGroupsListValue != null) {
                    request.addParameter("GroupId." + groupsListIndex, StringUtils.fromString((String)modifyInstanceAttributeRequestGroupsListValue));
                }
                ++groupsListIndex;
            }
        }
        if (modifyInstanceAttributeRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)modifyInstanceAttributeRequest.instanceId()));
        }
        if (modifyInstanceAttributeRequest.instanceInitiatedShutdownBehavior() != null) {
            request.addParameter("InstanceInitiatedShutdownBehavior.Value", StringUtils.fromString((String)modifyInstanceAttributeRequest.instanceInitiatedShutdownBehavior()));
        }
        if (modifyInstanceAttributeRequest.instanceType() != null) {
            request.addParameter("InstanceType.Value", StringUtils.fromString((String)modifyInstanceAttributeRequest.instanceType()));
        }
        if (modifyInstanceAttributeRequest.kernel() != null) {
            request.addParameter("Kernel.Value", StringUtils.fromString((String)modifyInstanceAttributeRequest.kernel()));
        }
        if (modifyInstanceAttributeRequest.ramdisk() != null) {
            request.addParameter("Ramdisk.Value", StringUtils.fromString((String)modifyInstanceAttributeRequest.ramdisk()));
        }
        if (modifyInstanceAttributeRequest.sriovNetSupport() != null) {
            request.addParameter("SriovNetSupport.Value", StringUtils.fromString((String)modifyInstanceAttributeRequest.sriovNetSupport()));
        }
        if (modifyInstanceAttributeRequest.userData() != null) {
            request.addParameter("UserData.Value", StringUtils.fromString((String)modifyInstanceAttributeRequest.userData()));
        }
        if (modifyInstanceAttributeRequest.value() != null) {
            request.addParameter("Value", StringUtils.fromString((String)modifyInstanceAttributeRequest.value()));
        }
        return request;
    }
}

