/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.ModifyHostsRequest;
import software.amazon.awssdk.util.StringUtils;

public class ModifyHostsRequestMarshaller
implements Marshaller<Request<ModifyHostsRequest>, ModifyHostsRequest> {
    public Request<ModifyHostsRequest> marshall(ModifyHostsRequest modifyHostsRequest) {
        SdkInternalList modifyHostsRequestHostIdsList;
        if (modifyHostsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyHostsRequest, "EC2Client");
        request.addParameter("Action", "ModifyHosts");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyHostsRequest.autoPlacement() != null) {
            request.addParameter("AutoPlacement", StringUtils.fromString((String)modifyHostsRequest.autoPlacement()));
        }
        if (!(modifyHostsRequestHostIdsList = (SdkInternalList)modifyHostsRequest.hostIds()).isEmpty() || !modifyHostsRequestHostIdsList.isAutoConstruct()) {
            int hostIdsListIndex = 1;
            for (String modifyHostsRequestHostIdsListValue : modifyHostsRequestHostIdsList) {
                if (modifyHostsRequestHostIdsListValue != null) {
                    request.addParameter("HostId." + hostIdsListIndex, StringUtils.fromString((String)modifyHostsRequestHostIdsListValue));
                }
                ++hostIdsListIndex;
            }
        }
        return request;
    }
}

