/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecification;
import software.amazon.awssdk.services.ec2.model.LaunchSpecification;
import software.amazon.awssdk.services.ec2.transform.BlockDeviceMappingUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.GroupIdentifierUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.IamInstanceProfileSpecificationUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.InstanceNetworkInterfaceSpecificationUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.SpotPlacementUnmarshaller;

public class LaunchSpecificationUnmarshaller
implements Unmarshaller<LaunchSpecification, StaxUnmarshallerContext> {
    private static LaunchSpecificationUnmarshaller INSTANCE;

    public LaunchSpecification unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        LaunchSpecification.Builder launchSpecification = LaunchSpecification.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("userData", targetDepth)) {
                    launchSpecification.userData(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("addressingType", targetDepth)) {
                    launchSpecification.addressingType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("blockDeviceMapping", targetDepth)) {
                    launchSpecification.blockDeviceMappings(new ArrayList<BlockDeviceMapping>());
                    continue;
                }
                if (context.testExpression("blockDeviceMapping/item", targetDepth)) {
                    launchSpecification.blockDeviceMappings(BlockDeviceMappingUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ebsOptimized", targetDepth)) {
                    launchSpecification.ebsOptimized(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("iamInstanceProfile", targetDepth)) {
                    launchSpecification.iamInstanceProfile(IamInstanceProfileSpecificationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("imageId", targetDepth)) {
                    launchSpecification.imageId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("instanceType", targetDepth)) {
                    launchSpecification.instanceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("kernelId", targetDepth)) {
                    launchSpecification.kernelId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("keyName", targetDepth)) {
                    launchSpecification.keyName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("networkInterfaceSet", targetDepth)) {
                    launchSpecification.networkInterfaces(new ArrayList<InstanceNetworkInterfaceSpecification>());
                    continue;
                }
                if (context.testExpression("networkInterfaceSet/item", targetDepth)) {
                    launchSpecification.networkInterfaces(InstanceNetworkInterfaceSpecificationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("placement", targetDepth)) {
                    launchSpecification.placement(SpotPlacementUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ramdiskId", targetDepth)) {
                    launchSpecification.ramdiskId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("subnetId", targetDepth)) {
                    launchSpecification.subnetId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("groupSet", targetDepth)) {
                    launchSpecification.allSecurityGroups(new ArrayList<GroupIdentifier>());
                    continue;
                }
                if (context.testExpression("groupSet/item", targetDepth)) {
                    launchSpecification.allSecurityGroups(GroupIdentifierUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("monitoring/enabled", targetDepth)) {
                    launchSpecification.monitoringEnabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("securityGroup", targetDepth)) {
                    launchSpecification.securityGroups(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("securityGroup/GroupName", targetDepth)) continue;
                launchSpecification.securityGroups(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (LaunchSpecification)launchSpecification.build();
    }

    public static LaunchSpecificationUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LaunchSpecificationUnmarshaller();
        }
        return INSTANCE;
    }
}

